/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demos.helpdesk;

import org.apache.log4j.Logger;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.demos.helpdesk.Ticket;
import org.switchyard.quickstarts.demos.helpdesk.TicketAck;
import org.switchyard.quickstarts.demos.helpdesk.TicketManagementService;

@Service(value=TicketManagementService.class)
public class TicketManagementServiceBean
implements TicketManagementService {
    private static final Logger LOGGER = Logger.getLogger(TicketManagementServiceBean.class);

    public TicketAck openTicket(Ticket ticket) {
        this.log("opening ticket");
        ticket.setStatus("opened");
        return new TicketAck().setId(ticket.getId()).setReceived(true);
    }

    public void approveTicket(Ticket ticket) {
        this.log("approving ticket");
        ticket.setStatus("approved");
    }

    public void closeTicket(Ticket ticket) {
        this.log("closing ticket");
        ticket.setStatus("closed");
    }

    public void requestDetails(Ticket ticket) {
        this.log("requesting details");
        ticket.setStatus("requested");
    }

    public void rejectTicket(Ticket ticket) {
        this.log("rejecting ticket");
        ticket.setStatus("rejected");
    }

    private void log(String msg) {
        LOGGER.info((Object)("********** " + msg + " **********"));
    }
}

