/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demo.policy.security.basic.propagate;

import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeSecurity;
import org.switchyard.annotations.Requires;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.policy.SecurityPolicy;
import org.switchyard.quickstarts.demo.policy.security.basic.propagate.BackEndService;
import org.switchyard.quickstarts.demo.policy.security.basic.propagate.Work;
import org.switchyard.quickstarts.demo.policy.security.basic.propagate.WorkAck;
import org.switchyard.quickstarts.demo.policy.security.basic.propagate.WorkService;

@Requires(security={SecurityPolicy.CONFIDENTIALITY, SecurityPolicy.CLIENT_AUTHENTICATION, SecurityPolicy.AUTHORIZATION})
@Service(value=WorkService.class)
public class WorkServiceBean
implements WorkService {
    private static final Logger LOGGER = Logger.getLogger(WorkServiceBean.class);
    private static final String MSG_1 = ":: WorkService :: Received work command => %s (caller principal=%s, in roles? 'friend'=%s 'enemy'=%s)";
    private static final String MSG_2 = ":: WorkService :: BackEndService received => %s";
    @Inject
    private Exchange exchange;
    @Inject
    @Reference
    private BackEndService backEndService;

    @Override
    public WorkAck doWork(Work work) {
        String cmd = work.getCommand();
        ExchangeSecurity es = this.exchange.getSecurity();
        String msg1 = String.format(MSG_1, cmd, es.getCallerPrincipal(), es.isCallerInRole("friend"), es.isCallerInRole("enemy"));
        LOGGER.info((Object)msg1);
        String back = this.backEndService.process(cmd);
        String msg2 = String.format(MSG_2, back);
        LOGGER.info((Object)msg2);
        return new WorkAck().setCommand(cmd).setReceived(true);
    }
}

