/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.endpoint;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceFeature;
import org.jboss.logging.Logger;
import org.switchyard.common.type.Classes;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.SOAPLogger;
import org.switchyard.component.soap.endpoint.BaseWebService;

public class JAXWSEndpoint
implements org.switchyard.component.common.Endpoint {
    private static final Logger LOGGER = Logger.getLogger(JAXWSEndpoint.class);
    private Endpoint _endpoint;
    private String _publishUrl;

    public JAXWSEndpoint(String bindingId, InboundHandler handler, WebServiceFeature ... features) {
        BaseWebService wsProvider = new BaseWebService();
        wsProvider.setInvocationClassLoader(Classes.getTCCL());
        wsProvider.setConsumer(handler);
        try {
            this._endpoint = Endpoint.create((String)bindingId, (Object)wsProvider, (WebServiceFeature[])features);
        }
        catch (NoSuchMethodError t) {
            this._endpoint = Endpoint.create((String)bindingId, (Object)wsProvider);
            try {
                Method method = this._endpoint.getBinding().getClass().getSuperclass().getMethod("addFeature", WebServiceFeature.class);
                for (WebServiceFeature feature : features) {
                    method.invoke((Object)this._endpoint.getBinding(), feature);
                }
            }
            catch (NoSuchMethodException nsme) {
                LOGGER.error((Object)nsme);
            }
            catch (IllegalAccessException iae) {
                LOGGER.error((Object)iae);
            }
            catch (InvocationTargetException ite) {
                LOGGER.error((Object)ite);
            }
        }
    }

    public Endpoint getEndpoint() {
        return this._endpoint;
    }

    public void publish(String publishUrl) {
        this._publishUrl = publishUrl;
        SOAPLogger.ROOT_LOGGER.publishingWebServiceAt(this._publishUrl);
        this._endpoint.publish(this._publishUrl);
    }

    public void start() {
    }

    public void stop() {
        SOAPLogger.ROOT_LOGGER.stoppingWebServiceAt(this._publishUrl);
        this._endpoint.stop();
    }
}

