/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Binding;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.soap.AddressingHandler;
import org.switchyard.component.soap.Feature;
import org.switchyard.component.soap.OutboundResponseHandler;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.WebServiceConsumeException;
import org.switchyard.component.soap.composer.SOAPBindingData;
import org.switchyard.component.soap.composer.SOAPComposition;
import org.switchyard.component.soap.composer.SOAPFaultInfo;
import org.switchyard.component.soap.composer.SOAPMessageComposer;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;
import org.switchyard.deploy.BaseServiceHandler;

public class OutboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(OutboundHandler.class);
    private static final String NO_RESPONSE = "No response returned.";
    private final SOAPBindingModel _config;
    private MessageComposer<SOAPBindingData> _messageComposer;
    private Dispatch<SOAPMessage> _dispatcher;
    private Port _wsdlPort;
    private String _bindingId;
    private Boolean _documentStyle;
    private Feature _feature = new Feature();

    public OutboundHandler(SOAPBindingModel config) {
        this._config = config;
    }

    public void start() throws WebServiceConsumeException {
        if (this._dispatcher == null) {
            ClassLoader origLoader = Classes.getTCCL();
            try {
                Definition definition = WSDLUtil.readWSDL(this._config.getWsdl());
                PortName portName = this._config.getPort();
                javax.wsdl.Service wsdlService = WSDLUtil.getService(definition, portName);
                this._wsdlPort = WSDLUtil.getPort(wsdlService, portName);
                portName.setServiceQName(wsdlService.getQName());
                portName.setName(this._wsdlPort.getName());
                String style = WSDLUtil.getStyle(this._wsdlPort);
                this._documentStyle = style.equals("document");
                this._feature = WSDLUtil.getFeature(definition, this._wsdlPort, this._documentStyle);
                MTOMFeature mtom = this._feature.getMtom(this._config);
                this._bindingId = WSDLUtil.getBindingId(this._wsdlPort, mtom.isEnabled());
                this._messageComposer = SOAPComposition.getMessageComposer(this._config);
                ((SOAPMessageComposer)this._messageComposer).setDocumentStyle(this._documentStyle);
                ((SOAPMessageComposer)this._messageComposer).setWsdlPort(this._wsdlPort);
                ((SOAPMessageComposer)this._messageComposer).setMtomEnabled(mtom.isEnabled());
                if (this._config.getMtomConfig() != null) {
                    ((SOAPMessageComposer)this._messageComposer).setXopExpand(this._config.getMtomConfig().isXopExpand());
                }
                URL wsdlUrl = WSDLUtil.getURL(this._config.getWsdl());
                LOGGER.info((Object)("Creating dispatch with WSDL " + wsdlUrl));
                Classes.setTCCL((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                Service service = Service.create((URL)wsdlUrl, (QName)portName.getServiceQName());
                this._dispatcher = service.createDispatch(portName.getPortQName(), SOAPMessage.class, Service.Mode.MESSAGE, new WebServiceFeature[]{this._feature.getAddressing(), mtom});
                Binding binding = this._dispatcher.getBinding();
                List handlers = binding.getHandlerChain();
                handlers.add(new OutboundResponseHandler());
                if (this._feature.isAddressingEnabled().booleanValue()) {
                    handlers.add(new AddressingHandler());
                } else {
                    this._dispatcher.getRequestContext().put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
                }
                binding.setHandlerChain(handlers);
                if (this._config.getEndpointAddress() != null) {
                    this._dispatcher.getRequestContext().put("javax.xml.ws.service.endpoint.address", this._config.getEndpointAddress());
                }
            }
            catch (MalformedURLException e) {
                throw new WebServiceConsumeException(e);
            }
            catch (WSDLException wsdle) {
                throw new WebServiceConsumeException(wsdle);
            }
            finally {
                Classes.setTCCL((ClassLoader)origLoader);
            }
        }
    }

    public void stop() {
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        try {
            SOAPMessage response;
            SOAPMessage request;
            if (SOAPUtil.getFactory(this._bindingId) == null) {
                throw new SOAPException("Failed to instantiate SOAP Message Factory");
            }
            Boolean oneWay = false;
            Boolean replyToSet = false;
            String action = null;
            try {
                request = ((SOAPBindingData)this._messageComposer.decompose(exchange, (BindingData)new SOAPBindingData(SOAPUtil.createMessage(this._bindingId)))).getSOAPMessage();
                QName firstBodyElement = SOAPUtil.getFirstBodyElement(request);
                action = WSDLUtil.getSoapAction(this._wsdlPort, firstBodyElement, this._documentStyle);
                oneWay = WSDLUtil.isOneWay(this._wsdlPort, firstBodyElement, this._documentStyle);
                if (this._feature.isAddressingEnabled().booleanValue()) {
                    String toAddress;
                    this._dispatcher.getRequestContext().put("SWITCHYARD_CONTEXT", exchange.getContext());
                    if (exchange.getContext().getPropertyValue(SOAPUtil.WSA_REPLYTO_STR) != null || exchange.getContext().getPropertyValue(SOAPUtil.WSA_REPLYTO_STR.toLowerCase()) != null) {
                        replyToSet = true;
                    }
                    if ((toAddress = SOAPUtil.getToAddress(exchange.getContext())) != null) {
                        this._dispatcher.getRequestContext().put("javax.xml.ws.service.endpoint.address", toAddress);
                    }
                }
            }
            catch (Exception e) {
                throw e instanceof SOAPException ? (SOAPException)((Object)e) : new SOAPException((Throwable)e);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Outbound ---> Request:[" + SOAPUtil.soapMessageToString(request) + "]" + (oneWay != false ? " oneWay " : "")));
            }
            if ((response = this.invokeService(request, oneWay, action)) != null) {
                Message message;
                Boolean hasFault = response.getSOAPBody().hasFault();
                try {
                    SOAPBindingData bindingData = new SOAPBindingData(response);
                    if (hasFault.booleanValue()) {
                        SOAPFaultInfo faultInfo = new SOAPFaultInfo();
                        faultInfo.copyFaultInfo(response);
                        bindingData.setSOAPFaultInfo(faultInfo);
                    }
                    String status = (String)response.getProperty("org.switchyard.http.status");
                    if (!hasFault.booleanValue() && status != null) {
                        bindingData.setStatus(Integer.valueOf(status));
                    }
                    message = this._messageComposer.compose((BindingData)bindingData, exchange);
                }
                catch (Exception e) {
                    throw e instanceof SOAPException ? (SOAPException)((Object)e) : new SOAPException((Throwable)e);
                }
                if (hasFault.booleanValue()) {
                    exchange.sendFault(message);
                } else {
                    exchange.send(message);
                }
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Outbound <--- Response:[" + SOAPUtil.soapMessageToString(response) + "]"));
            }
        }
        catch (SOAPException se) {
            throw new HandlerException("Unexpected exception handling SOAP Message", (Throwable)se);
        }
    }

    private SOAPMessage invokeService(SOAPMessage soapMessage, Boolean oneWay, String action) throws SOAPException {
        SOAPMessage response = null;
        try {
            if (!this._feature.isAddressingEnabled().booleanValue() && action != null) {
                this._dispatcher.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", "\"" + action + "\"");
            }
            if (oneWay.booleanValue()) {
                this._dispatcher.invokeOneWay((Object)soapMessage);
            } else {
                response = (SOAPMessage)this._dispatcher.invoke((Object)soapMessage);
            }
        }
        catch (SOAPFaultException sfex) {
            response = SOAPUtil.generateFault(sfex, this._bindingId);
        }
        catch (WebServiceException wsex) {
            if (wsex.getMessage().equals(NO_RESPONSE) && this._feature.isAddressingEnabled().booleanValue()) {
                LOGGER.warn((Object)"Sent a message with ReplyTo to a Request_Response Webservice, so no response returned!");
            }
            throw new SOAPException((Throwable)wsex);
        }
        catch (Exception ex) {
            throw new SOAPException("Cannot process SOAP request", (Throwable)ex);
        }
        return response;
    }
}

