/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.NamespaceAware;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.Classes;
import org.switchyard.component.camel.CamelComponentMessages;
import org.switchyard.component.camel.model.CamelComponentImplementationModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class RouteFactory {
    private static JAXBContext JAXB_CONTEXT;

    private RouteFactory() {
    }

    public static List<RouteDefinition> getRoutes(CamelComponentImplementationModel model) {
        if (model.getJavaClass() != null) {
            return RouteFactory.createRoute(model.getJavaClass(), model.getComponent().getTargetNamespace());
        }
        return RouteFactory.loadRoute(model.getXMLPath());
    }

    public static List<RouteDefinition> loadRoute(String xmlPath) {
        ArrayList<RouteDefinition> routes = null;
        try {
            InputSource source = new InputSource(Classes.getResourceAsStream((String)xmlPath));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(source);
            Element element = document.getDocumentElement();
            Binder binder = JAXB_CONTEXT.createBinder();
            Object obj = binder.unmarshal((Object)element);
            RouteFactory.injectNamespaces(element, (Binder<Node>)binder);
            if (obj instanceof RoutesDefinition) {
                routes = ((RoutesDefinition)obj).getRoutes();
            } else if (obj instanceof RouteDefinition) {
                routes = new ArrayList<RouteDefinition>(1);
                routes.add((RouteDefinition)obj);
            }
            if (routes == null) {
                CamelComponentMessages.MESSAGES.noRoutesFoundInXMLFile(xmlPath);
            }
            return routes;
        }
        catch (SAXException e) {
            throw new SwitchYardException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new SwitchYardException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new SwitchYardException((Throwable)e);
        }
        catch (IOException e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    private static void injectNamespaces(Element element, Binder<Node> binder) {
        NodeList list = element.getChildNodes();
        Namespaces namespaces = null;
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = list.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            Object object = binder.getJAXBNode((Object)child);
            if (object instanceof NamespaceAware) {
                NamespaceAware namespaceAware = (NamespaceAware)object;
                if (namespaces == null) {
                    namespaces = new Namespaces(element);
                }
                namespaces.configure(namespaceAware);
            }
            RouteFactory.injectNamespaces(childElement, binder);
        }
    }

    public static List<RouteDefinition> createRoute(String className) {
        return RouteFactory.createRoute(className, null);
    }

    public static List<RouteDefinition> createRoute(String className, String namespace) {
        Class clazz = Classes.forName((String)className);
        if (clazz == null) {
            throw CamelComponentMessages.MESSAGES.invalidJavaDSLClassSpecified(className);
        }
        return RouteFactory.createRoute(clazz, namespace);
    }

    public static List<RouteDefinition> createRoute(Class<?> routeClass) {
        return RouteFactory.createRoute(routeClass, null);
    }

    public static List<RouteDefinition> createRoute(Class<?> routeClass, String namespace) {
        if (!RouteBuilder.class.isAssignableFrom(routeClass)) {
            throw CamelComponentMessages.MESSAGES.javaDSLClassMustExtend(routeClass.getName(), RouteBuilder.class.getName());
        }
        try {
            RouteBuilder builder = (RouteBuilder)routeClass.newInstance();
            builder.configure();
            List routes = builder.getRouteCollection().getRoutes();
            if (routes.isEmpty()) {
                throw CamelComponentMessages.MESSAGES.noRoutesFoundinJavaDSLClass(routeClass.getName());
            }
            return routes;
        }
        catch (Exception ex) {
            throw CamelComponentMessages.MESSAGES.failedToInitializeDSLClass(routeClass.getName(), ex);
        }
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.model.rest", (ClassLoader)CamelContext.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new SwitchYardException((Throwable)e);
        }
    }
}

