/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.composer;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.composer.BaseContextMapper;

public class CamelContextMapper
extends BaseContextMapper<Message> {
    public void mapFrom(Message source, Context context) throws Exception {
        Object value;
        String name;
        Exchange exchange = source.getExchange();
        for (Map.Entry header : source.getHeaders().entrySet()) {
            name = (String)header.getKey();
            if (!this.matches(name) || (value = header.getValue()) == null) continue;
            context.setProperty(name, value, Scope.IN);
        }
        for (Map.Entry property : exchange.getProperties().entrySet()) {
            name = (String)property.getKey();
            if (!this.matches(name) || (value = property.getValue()) == null) continue;
            context.setProperty(name, value, Scope.EXCHANGE);
        }
    }

    public void mapTo(Context context, Message target) throws Exception {
        Object value;
        String name;
        Exchange exchange = target.getExchange();
        for (Property property : context.getProperties(Scope.OUT)) {
            name = property.getName();
            if (!this.matches(name) || (value = property.getValue()) == null) continue;
            target.setHeader(name, value);
        }
        for (Property property : context.getProperties(Scope.EXCHANGE)) {
            name = property.getName();
            if (!this.matches(name) || (value = property.getValue()) == null) continue;
            exchange.setProperty(name, value);
        }
    }
}

