/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import javax.xml.namespace.QName;
import org.apache.camel.Message;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.ServiceReference;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.component.camel.composer.CamelMessageComposer;
import org.switchyard.component.camel.deploy.ServiceReferences;
import org.switchyard.composer.MessageComposer;
import org.switchyard.exception.SwitchYardException;

public class CamelResponseHandler
implements ExchangeHandler {
    private final org.apache.camel.Exchange _camelExchange;
    private final ServiceReference _reference;
    private final MessageComposer<Message> _messageComposer;

    public CamelResponseHandler(org.apache.camel.Exchange camelExchange, ServiceReference reference, MessageComposer<Message> messageComposer) {
        if (camelExchange == null) {
            throw new SwitchYardException("[camelExchange] argument must not be null");
        }
        if (reference == null) {
            throw new SwitchYardException("[reference] argument must not be null");
        }
        this._camelExchange = camelExchange;
        this._reference = reference;
        this._messageComposer = messageComposer;
    }

    public void handleMessage(final Exchange switchYardExchange) throws HandlerException {
        CamelMessageComposer.ContentTypeProvider ctp = new CamelMessageComposer.ContentTypeProvider(){

            @Override
            public Class<?> getContentType() {
                QName outputType = ServiceReferences.getOutputTypeForExchange(CamelResponseHandler.this._reference, switchYardExchange);
                if (outputType != null) {
                    return QNameUtil.toJavaMessageType((QName)outputType);
                }
                return null;
            }
        };
        try {
            CamelMessageComposer.setContentTypeProvider(switchYardExchange, ctp);
            this._messageComposer.decompose(switchYardExchange, (Object)this._camelExchange.getIn());
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
        finally {
            CamelMessageComposer.setContentTypeProvider(switchYardExchange, null);
        }
    }

    public void handleFault(Exchange exchange) {
        Object content = exchange.getMessage().getContent();
        if (content instanceof Throwable) {
            this._camelExchange.setException((Throwable)content);
        }
    }
}

