/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task;

import java.io.IOException;
import java.net.Socket;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.switchyard.common.io.pull.PropertiesPuller;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.bpm.task.TaskServer;
import org.switchyard.exception.SwitchYardException;

public abstract class BaseTaskServer
implements TaskServer {
    private static final Logger LOGGER = Logger.getLogger(BaseTaskServer.class);
    private String _host = "127.0.0.1";
    private int _port = 9123;
    private boolean _started = false;
    private String _usersPath = "/users.properties";
    private String _groupsPath = "/roles.properties";

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public TaskServer setHost(String host) {
        this._host = host;
        return this;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public TaskServer setPort(int port) {
        this._port = port;
        return this;
    }

    @Override
    public boolean isStarted() {
        return this._started;
    }

    protected TaskServer setStarted(boolean started) {
        this._started = started;
        return this;
    }

    @Override
    public String getUsersPath() {
        return this._usersPath;
    }

    @Override
    public TaskServer setUsersPath(String usersPath) {
        this._usersPath = usersPath;
        return this;
    }

    protected Properties getUsersProperties() {
        try {
            return (Properties)new PropertiesPuller().pull(this.getUsersPath(), this.getClass());
        }
        catch (IOException ioe) {
            throw new SwitchYardException((Throwable)ioe);
        }
    }

    protected Set<String> getUsersSet(String ... initialUsers) {
        LinkedHashSet<String> usersSet = new LinkedHashSet<String>();
        for (String initialUser : initialUsers) {
            String user = Strings.trimToNull((String)initialUser);
            if (user == null) continue;
            usersSet.add(user);
        }
        Properties usersProperties = this.getUsersProperties();
        if (usersProperties != null) {
            for (Object key : usersProperties.keySet()) {
                String user = Strings.trimToNull((String)((String)key));
                if (user == null) continue;
                usersSet.add(user);
            }
        }
        return usersSet;
    }

    @Override
    public String getGroupsPath() {
        return this._groupsPath;
    }

    @Override
    public TaskServer setGroupsPath(String groupsPath) {
        this._groupsPath = groupsPath;
        return this;
    }

    protected Properties getGroupsProperties() {
        try {
            return (Properties)new PropertiesPuller().pull(this.getGroupsPath(), this.getClass());
        }
        catch (IOException ioe) {
            throw new SwitchYardException((Throwable)ioe);
        }
    }

    protected Set<String> getGroupsSet(String ... initialGroups) {
        LinkedHashSet<String> groupsSet = new LinkedHashSet<String>();
        for (String initialGroup : initialGroups) {
            String group = Strings.trimToNull((String)initialGroup);
            if (group == null) continue;
            groupsSet.add(group);
        }
        Properties groupsProperties = this.getGroupsProperties();
        if (groupsProperties != null) {
            for (Object key : groupsProperties.keySet()) {
                String value = groupsProperties.getProperty((String)key);
                StringTokenizer st = new StringTokenizer(value, ",");
                while (st.hasMoreTokens()) {
                    String group = Strings.trimToNull((String)st.nextToken());
                    if (group == null) continue;
                    groupsSet.add(group);
                }
            }
        }
        return groupsSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean waitForPort(boolean wantFree) {
        int attempts = 0;
        boolean ready = false;
        while (!ready && attempts < 11) {
            ++attempts;
            Socket socket = null;
            try {
                socket = new Socket(this.getHost(), this.getPort());
                boolean connected = socket.isConnected();
                if (wantFree && connected || !wantFree && !connected) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        LOGGER.trace((Object)ie.getMessage());
                    }
                    continue;
                }
                ready = true;
            }
            catch (IOException ioe) {
                if (wantFree) {
                    ready = true;
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    LOGGER.trace((Object)ie.getMessage());
                }
            }
            finally {
                if (socket == null) continue;
                try {
                    try {
                        socket.close();
                        socket = null;
                    }
                    catch (IOException ioe) {
                        LOGGER.warn((Object)ioe.getMessage());
                        socket = null;
                    }
                }
                catch (Throwable throwable) {
                    socket = null;
                    throw throwable;
                }
            }
        }
        return ready;
    }
}

