/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.internal.context;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;

@ApplicationScoped
public class ContextProxy
implements Context {
    private static ThreadLocal<Context> _context = new ThreadLocal();

    public Property getProperty(String name) {
        return ContextProxy.getContext().getProperty(name);
    }

    public Property getProperty(String name, Scope scope) {
        return ContextProxy.getContext().getProperty(name, scope);
    }

    public Object getPropertyValue(String name) {
        return ContextProxy.getContext().getPropertyValue(name);
    }

    public Set<Property> getProperties() {
        return ContextProxy.getContext().getProperties();
    }

    public Set<Property> getProperties(Scope scope) {
        return ContextProxy.getContext().getProperties(scope);
    }

    public void removeProperty(Property property) {
        ContextProxy.getContext().removeProperty(property);
    }

    public void removeProperties() {
        ContextProxy.getContext().removeProperties();
    }

    public void removeProperties(Scope scope) {
        ContextProxy.getContext().removeProperties(scope);
    }

    public Context setProperty(String name, Object val) {
        return ContextProxy.getContext().setProperty(name, val);
    }

    public Context setProperty(String name, Object val, Scope scope) {
        return ContextProxy.getContext().setProperty(name, val, scope);
    }

    public Context setProperties(Set<Property> properties) {
        return ContextProxy.getContext().setProperties(properties);
    }

    public static void setContext(Context context) {
        if (context != null) {
            _context.set(context);
        } else {
            _context.remove();
        }
    }

    private static Context getContext() {
        Context context = _context.get();
        if (context == null) {
            throw new UnsupportedOperationException("Illegal call to get the SwitchYard Exchange Context.  Must be called within the scope of an Exchange Handler Chain.");
        }
        return context;
    }
}

