/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.service;

import ch.qos.logback.access.jetty.RequestLogImpl;
import ch.qos.logback.access.servlet.TeeFilter;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.chemistry.opencmis.server.impl.CmisRepositoryContextListener;
import org.apache.chemistry.opencmis.server.impl.atompub.CmisAtomPubServlet;
import org.apache.chemistry.opencmis.server.impl.browser.CmisBrowserBindingServlet;
import org.apache.chemistry.opencmis.server.shared.BasicAuthCallContextHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.AsyncGzipFilter;
import org.eclipse.jetty.servlets.GzipFilter;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.structr.api.service.Command;
import org.structr.api.service.RunnableService;
import org.structr.api.service.StructrServices;
import org.structr.core.Services;
import org.structr.core.auth.SuperUserAuthenticator;
import org.structr.rest.DefaultResourceProvider;
import org.structr.rest.ResourceProvider;
import org.structr.rest.service.HttpServiceLifecycleListener;
import org.structr.rest.service.HttpServiceServlet;
import org.structr.rest.servlet.JsonRestServlet;
import org.tuckey.web.filters.urlrewrite.UrlRewriteFilter;

public class HttpService
implements RunnableService {
    private static final Logger logger = Logger.getLogger(HttpService.class.getName());
    public static final String SERVLETS = "HttpService.servlets";
    public static final String RESOURCE_HANDLERS = "HttpService.resourceHandlers";
    public static final String LIFECYCLE_LISTENERS = "HttpService.lifecycle.listeners";
    public static final String MAIN_CLASS = "HttpService.mainClass";
    public static final String ASYNC = "HttpService.async";
    public static final String APPLICATION_TITLE = "application.title";
    public static final String APPLICATION_HOST = "application.host";
    public static final String APPLICATION_HTTP_PORT = "application.http.port";
    public static final String APPLICATION_HTTPS_PORT = "application.https.port";
    public static final String APPLICATION_HTTPS_ENABLED = "application.https.enabled";
    public static final String APPLICATION_KEYSTORE_PATH = "application.keystore.path";
    public static final String APPLICATION_KEYSTORE_PASSWORD = "application.keystore.password";
    private Set<ResourceProvider> resourceProviders = new LinkedHashSet<ResourceProvider>();
    private Server server = null;
    private String basePath = null;
    private String applicationName = null;
    private String host = null;
    private boolean async = true;
    private int httpPort = 8082;
    private int maxIdleTime = 30000;
    private int requestHeaderSize = 8192;
    private HashSessionManager hashSessionManager = null;
    private HttpConfiguration httpConfig;
    private HttpConfiguration httpsConfig;

    public void startService() {
        logger.log(Level.INFO, "Starting {0} (host={1}:{2}, maxIdleTime={3}, requestHeaderSize={4})", new Object[]{this.applicationName, this.host, String.valueOf(this.httpPort), String.valueOf(this.maxIdleTime), String.valueOf(this.requestHeaderSize)});
        logger.log(Level.INFO, "Base path {0}", this.basePath);
        logger.log(Level.INFO, "{0} started at http://{1}:{2}", new Object[]{this.applicationName, String.valueOf(this.host), String.valueOf(this.httpPort)});
        try {
            this.server.start();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Unable to start HTTP service: {0}", ex);
        }
        this.removeDir(this.basePath, "jsp");
        this.sendLifecycleEvent(LifecycleEvent.Started);
    }

    public void stopService() {
    }

    public boolean runOnStartup() {
        return true;
    }

    public boolean isRunning() {
        return this.server != null && this.server.isRunning();
    }

    public void injectArguments(Command command) {
    }

    public void initialize(StructrServices services, Properties additionalConfig) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        File baseDir;
        Properties finalConfig = new Properties();
        finalConfig.setProperty(APPLICATION_TITLE, "structr server");
        finalConfig.setProperty(APPLICATION_HOST, "0.0.0.0");
        finalConfig.setProperty(APPLICATION_HTTP_PORT, "8082");
        finalConfig.setProperty(APPLICATION_HTTPS_ENABLED, "false");
        finalConfig.setProperty(APPLICATION_HTTPS_PORT, "8083");
        finalConfig.setProperty(ASYNC, "true");
        finalConfig.setProperty(SERVLETS, "JsonRestServlet");
        finalConfig.setProperty("JsonRestServlet.class", JsonRestServlet.class.getName());
        finalConfig.setProperty("JsonRestServlet.path", "/structr/rest/*");
        finalConfig.setProperty("JsonRestServlet.resourceprovider", DefaultResourceProvider.class.getName());
        finalConfig.setProperty("JsonRestServlet.authenticator", SuperUserAuthenticator.class.getName());
        finalConfig.setProperty("JsonRestServlet.user.class", "org.structr.dynamic.User");
        finalConfig.setProperty("JsonRestServlet.user.autocreate", "false");
        finalConfig.setProperty("JsonRestServlet.defaultview", "public");
        finalConfig.setProperty("JsonRestServlet.outputdepth", "3");
        StructrServices.mergeConfiguration((Properties)finalConfig, (Properties)additionalConfig);
        String mainClassName = (String)finalConfig.get(MAIN_CLASS);
        Class<?> mainClass = null;
        if (mainClassName != null) {
            logger.log(Level.INFO, "Running main class {0}", new Object[]{mainClassName});
            try {
                mainClass = Class.forName(mainClassName);
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.WARNING, "Did not find class for main class from config " + mainClassName, ex);
            }
        }
        String sourceJarName = (mainClass != null ? mainClass : this.getClass()).getProtectionDomain().getCodeSource().getLocation().toString();
        boolean isTest = Boolean.parseBoolean(finalConfig.getProperty("testing", "false"));
        if (!isTest && StringUtils.stripEnd((String)sourceJarName, (String)System.getProperty("file.separator")).endsWith("classes")) {
            String jarFile = System.getProperty("jarFile");
            if (StringUtils.isEmpty((CharSequence)jarFile)) {
                throw new IllegalArgumentException(this.getClass().getName() + " was started in an environment where the classloader cannot determine the JAR file containing the main class.\n" + "Please specify the path to the JAR file in the parameter -DjarFile.\n" + "Example: -DjarFile=${project.build.directory}/${project.artifactId}-${project.version}.jar");
            }
            sourceJarName = jarFile;
        }
        this.applicationName = finalConfig.getProperty(APPLICATION_TITLE);
        this.host = finalConfig.getProperty(APPLICATION_HOST);
        this.basePath = finalConfig.getProperty("base.path");
        this.httpPort = Services.parseInt((String)finalConfig.getProperty(APPLICATION_HTTP_PORT), (int)8082);
        this.maxIdleTime = Services.parseInt((String)System.getProperty("maxIdleTime"), (int)30000);
        this.requestHeaderSize = Services.parseInt((String)System.getProperty("requestHeaderSize"), (int)8192);
        this.async = Services.parseBoolean((String)finalConfig.getProperty(ASYNC), (boolean)true);
        if (this.async) {
            logger.log(Level.INFO, "Running in asynchronous mode");
        }
        String keyStorePath = finalConfig.getProperty(APPLICATION_KEYSTORE_PATH);
        String keyStorePassword = finalConfig.getProperty(APPLICATION_KEYSTORE_PASSWORD);
        String contextPath = System.getProperty("contextPath", "/");
        String logPrefix = "structr";
        boolean enableRewriteFilter = true;
        boolean enableHttps = Services.parseBoolean((String)finalConfig.getProperty(APPLICATION_HTTPS_ENABLED), (boolean)false);
        boolean enableGzipCompression = true;
        boolean logRequests = false;
        int httpsPort = Services.parseInt((String)finalConfig.getProperty(APPLICATION_HTTPS_PORT), (int)8083);
        this.basePath = System.getProperty("home", this.basePath);
        if (this.basePath.isEmpty()) {
            this.basePath = System.getProperty("user.dir", "/tmp");
        }
        if (!(baseDir = new File(this.basePath)).exists()) {
            baseDir.mkdirs();
        }
        this.server = new Server(this.httpPort);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.addHandler((Handler)new DefaultHandler());
        ServletContextHandler servletContext = new ServletContextHandler((HandlerContainer)this.server, contextPath, true, true);
        LinkedList<ServerConnector> connectors = new LinkedList<ServerConnector>();
        try {
            servletContext.setBaseResource((Resource)new ResourceCollection(new Resource[]{Resource.newResource((String)this.basePath), JarResource.newJarResource((Resource)Resource.newResource((String)sourceJarName))}));
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Base resource {0} not usable: {1}", new Object[]{this.basePath, t.getMessage()});
        }
        servletContext.addServlet("org.eclipse.jetty.servlet.DefaultServlet", "/");
        servletContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        try {
            servletContext.addEventListener((EventListener)new CmisRepositoryContextListener());
            ServletHolder cmisAtomHolder = servletContext.addServlet(CmisAtomPubServlet.class.getName(), "/structr/cmis/atom/*");
            cmisAtomHolder.setInitParameter("callContextHandler", BasicAuthCallContextHandler.class.getName());
            cmisAtomHolder.setInitParameter("cmisVersion", "1.1");
            ServletHolder cmisBrowserHolder = servletContext.addServlet(CmisBrowserBindingServlet.class.getName(), "/structr/cmis/browser/*");
            cmisBrowserHolder.setInitParameter("callContextHandler", BasicAuthCallContextHandler.class.getName());
            cmisBrowserHolder.setInitParameter("cmisVersion", "1.1");
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "", t);
        }
        this.hashSessionManager = new HashSessionManager();
        try {
            this.hashSessionManager.setStoreDirectory(new File(baseDir + "/sessions"));
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Could not set custom session manager with session store directory {0}/sessions", baseDir);
        }
        servletContext.getSessionHandler().setSessionManager((SessionManager)this.hashSessionManager);
        FilterHolder rewriteFilter = new FilterHolder(UrlRewriteFilter.class);
        rewriteFilter.setInitParameter("confPath", "urlrewrite.xml");
        servletContext.addFilter(rewriteFilter, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC));
        FilterHolder gzipFilter = this.async ? new FilterHolder(AsyncGzipFilter.class) : new FilterHolder(GzipFilter.class);
        gzipFilter.setInitParameter("mimeTypes", "text/html,text/plain,text/css,text/javascript,application/json");
        gzipFilter.setInitParameter("bufferSize", "32768");
        gzipFilter.setInitParameter("minGzipSize", "256");
        gzipFilter.setInitParameter("deflateCompressionLevel", "9");
        gzipFilter.setInitParameter("methods", "GET,POST,PUT,HEAD,DELETE");
        servletContext.addFilter(gzipFilter, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC));
        contexts.addHandler((Handler)servletContext);
        if ("true".equals(finalConfig.getProperty("log.requests", "false"))) {
            String logbackConfFilePath;
            Object logbackConfFile;
            String etcPath = this.basePath + "/etc";
            File etcDir = new File(etcPath);
            if (!etcDir.exists()) {
                etcDir.mkdir();
            }
            if (!((File)(logbackConfFile = new File(logbackConfFilePath = this.basePath + "/etc/logback-access.xml"))).exists()) {
                LinkedList<String> config = new LinkedList<String>();
                config.add("<configuration>");
                config.add("  <appender name=\"FILE\" class=\"ch.qos.logback.core.rolling.RollingFileAppender\">");
                config.add("    <rollingPolicy class=\"ch.qos.logback.core.rolling.TimeBasedRollingPolicy\">");
                config.add("      <fileNamePattern>logs/structr-%d{yyyy_MM_dd}.request.log.zip</fileNamePattern>");
                config.add("    </rollingPolicy>");
                config.add("    <encoder>");
                config.add("      <charset>UTF-8</charset>");
                config.add("      <pattern>%h %l %u %t \"%r\" %s %b %n%fullRequest%n%n%fullResponse</pattern>");
                config.add("    </encoder>");
                config.add("  </appender>");
                config.add("  <appender-ref ref=\"FILE\" />");
                config.add("</configuration>");
                try {
                    ((File)logbackConfFile).createNewFile();
                    FileUtils.writeLines((File)logbackConfFile, (String)"UTF-8", config);
                }
                catch (IOException ioex) {
                    logger.log(Level.WARNING, "Unable to write logback configuration.", ioex);
                }
            }
            FilterHolder loggingFilter = new FilterHolder(TeeFilter.class);
            servletContext.addFilter(loggingFilter, "/*", EnumSet.of(DispatcherType.REQUEST, this.async ? DispatcherType.ASYNC : DispatcherType.FORWARD));
            loggingFilter.setInitParameter("includes", "");
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            String logPath = this.basePath + "/logs";
            File logDir = new File(logPath);
            if (!logDir.exists()) {
                logDir.mkdir();
            }
            RequestLogImpl requestLog = new RequestLogImpl();
            requestLog.setName("REQUESTLOG");
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            HandlerCollection handlers = new HandlerCollection();
            handlers.setHandlers(new Handler[]{contexts, requestLogHandler});
            this.server.setHandler((Handler)handlers);
        } else {
            this.server.setHandler((Handler)contexts);
        }
        List<ContextHandler> resourceHandler = this.collectResourceHandlers(finalConfig);
        for (ContextHandler contextHandler : resourceHandler) {
            contexts.addHandler((Handler)contextHandler);
        }
        Map<String, ServletHolder> servlets = this.collectServlets(finalConfig);
        int position = 1;
        for (Map.Entry<String, ServletHolder> servlet : servlets.entrySet()) {
            ServletHolder servletHolder = servlet.getValue();
            String path = servlet.getKey();
            servletHolder.setInitOrder(position++);
            logger.log(Level.INFO, "Adding servlet {0} for {1}", new Object[]{servletHolder, path});
            servletContext.addServlet(servletHolder, path);
        }
        contexts.addHandler((Handler)servletContext);
        if (this.host != null && !this.host.isEmpty() && this.httpPort > -1) {
            this.httpConfig = new HttpConfiguration();
            this.httpConfig.setSecureScheme("https");
            this.httpConfig.setSecurePort(httpsPort);
            this.httpConfig.setRequestHeaderSize(this.requestHeaderSize);
            ServerConnector httpConnector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(this.httpConfig)});
            httpConnector.setHost(this.host);
            httpConnector.setPort(this.httpPort);
            connectors.add(httpConnector);
        } else {
            logger.log(Level.WARNING, "Unable to configure HTTP server port, please make sure that {0} and {1} are set correctly in structr.conf.", new Object[]{APPLICATION_HOST, APPLICATION_HTTP_PORT});
        }
        if (enableHttps) {
            if (httpsPort > -1 && keyStorePath != null && !keyStorePath.isEmpty() && keyStorePassword != null) {
                this.httpsConfig = new HttpConfiguration(this.httpConfig);
                this.httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                SslContextFactory sslContextFactory = new SslContextFactory();
                sslContextFactory.setKeyStorePath(keyStorePath);
                sslContextFactory.setKeyStorePassword(keyStorePassword);
                ServerConnector https = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(this.httpsConfig)});
                https.setPort(httpsPort);
                https.setIdleTimeout(500000L);
                https.setHost(this.host);
                https.setPort(httpsPort);
                connectors.add(https);
            } else {
                logger.log(Level.WARNING, "Unable to configure SSL, please make sure that {0}, {1} and {2} are set correctly in structr.conf.", new Object[]{APPLICATION_HTTPS_PORT, APPLICATION_KEYSTORE_PATH, APPLICATION_KEYSTORE_PASSWORD});
            }
        }
        if (!connectors.isEmpty()) {
            this.server.setConnectors(connectors.toArray(new Connector[0]));
        } else {
            logger.log(Level.SEVERE, "No connectors configured, aborting.");
            System.exit(0);
        }
        this.server.setStopTimeout(1000L);
        this.server.setStopAtShutdown(true);
    }

    public void initialized() {
    }

    public void shutdown() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Error while stopping Jetty server: {0}", ex.getMessage());
            }
        }
        this.sendLifecycleEvent(LifecycleEvent.Stopped);
    }

    public String getName() {
        return HttpService.class.getName();
    }

    public boolean isVital() {
        return true;
    }

    public Set<ResourceProvider> getResourceProviders() {
        return this.resourceProviders;
    }

    public HashSessionManager getHashSessionManager() {
        return this.hashSessionManager;
    }

    private List<ContextHandler> collectResourceHandlers(Properties properties) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        LinkedList<ContextHandler> resourceHandlers = new LinkedList<ContextHandler>();
        String resourceHandlerList = properties.getProperty(RESOURCE_HANDLERS, "");
        if (resourceHandlerList != null) {
            for (String resourceHandlerName : resourceHandlerList.split("[ \\t]+")) {
                String contextPath = properties.getProperty(resourceHandlerName.concat(".contextPath"));
                if (contextPath != null) {
                    String resourceBase = properties.getProperty(resourceHandlerName.concat(".resourceBase"));
                    if (resourceBase != null) {
                        String directoriesListed = properties.getProperty(resourceHandlerName.concat(".directoriesListed"));
                        if (directoriesListed != null) {
                            String welcomeFiles = properties.getProperty(resourceHandlerName.concat(".welcomeFiles"));
                            if (welcomeFiles != null) {
                                ResourceHandler resourceHandler = new ResourceHandler();
                                resourceHandler.setDirectoriesListed(Boolean.parseBoolean(directoriesListed));
                                resourceHandler.setWelcomeFiles(StringUtils.split((String)welcomeFiles));
                                resourceHandler.setResourceBase(resourceBase);
                                resourceHandler.setCacheControl("max-age=0");
                                resourceHandler.setEtags(true);
                                ContextHandler staticResourceHandler = new ContextHandler();
                                staticResourceHandler.setContextPath(contextPath);
                                staticResourceHandler.setHandler((Handler)resourceHandler);
                                resourceHandlers.add(staticResourceHandler);
                                continue;
                            }
                            logger.log(Level.WARNING, "Unable to register resource handler {0}, missing {0}.welcomeFiles", resourceHandlerName);
                            continue;
                        }
                        logger.log(Level.WARNING, "Unable to register resource handler {0}, missing {0}.resourceBase", resourceHandlerName);
                        continue;
                    }
                    logger.log(Level.WARNING, "Unable to register resource handler {0}, missing {0}.resourceBase", resourceHandlerName);
                    continue;
                }
                logger.log(Level.WARNING, "Unable to register resource handler {0}, missing {0}.contextPath", resourceHandlerName);
            }
        } else {
            logger.log(Level.WARNING, "No resource handlers configured for HttpService.");
        }
        return resourceHandlers;
    }

    private Map<String, ServletHolder> collectServlets(Properties properties) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        LinkedHashMap<String, ServletHolder> servlets = new LinkedHashMap<String, ServletHolder>();
        String servletNameList = properties.getProperty(SERVLETS, "");
        if (servletNameList != null) {
            for (String servletName : servletNameList.split("[ \\t]+")) {
                String servletClassName = properties.getProperty(servletName.concat(".class"));
                if (servletClassName != null) {
                    String servletPath = properties.getProperty(servletName.concat(".path"));
                    if (servletPath != null) {
                        HttpServlet servlet = (HttpServlet)Class.forName(servletClassName).newInstance();
                        if (servlet instanceof HttpServiceServlet) {
                            ((HttpServiceServlet)servlet).getConfig().initializeFromProperties(properties, servletName, this.resourceProviders);
                        }
                        if (servletPath.endsWith("*")) {
                            servlets.put(servletPath, new ServletHolder((Servlet)servlet));
                            continue;
                        }
                        servlets.put(servletPath + "/*", new ServletHolder((Servlet)servlet));
                        continue;
                    }
                    logger.log(Level.WARNING, "Unable to register servlet {0}, missing {0}.path", servletName);
                    continue;
                }
                logger.log(Level.WARNING, "Unable to register servlet {0}, missing {0}.class", servletName);
            }
        } else {
            logger.log(Level.WARNING, "No servlets configured for HttpService.");
        }
        return servlets;
    }

    private void removeDir(String basePath, String directoryName) {
        String strippedBasePath = StringUtils.stripEnd((String)basePath, (String)"/");
        File file = new File(strippedBasePath + "/" + directoryName);
        if (file.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Unable to delete directory {0}: {1}", new Object[]{directoryName, ex.getMessage()});
            }
        } else {
            file.delete();
        }
    }

    private void sendLifecycleEvent(LifecycleEvent event) {
        String listeners = Services.getInstance().getCurrentConfig().getProperty(LIFECYCLE_LISTENERS);
        if (listeners != null) {
            String[] listenerClasses;
            for (String listenerClass : listenerClasses = listeners.split("[\\s ,;]+")) {
                try {
                    HttpServiceLifecycleListener listener = (HttpServiceLifecycleListener)Class.forName(listenerClass).newInstance();
                    switch (event) {
                        case Started: {
                            listener.serverStarted();
                            break;
                        }
                        case Stopped: {
                            listener.serverStopped();
                        }
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    logger.log(Level.SEVERE, "Unable to send lifecycle event to listener " + listenerClass, ex);
                }
            }
        }
    }

    private static enum LifecycleEvent {
        Started,
        Stopped;

    }
}

