/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.structr.api.Predicate;
import org.structr.api.graph.Node;
import org.structr.api.util.Iterables;
import org.structr.common.PagingHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.PropertyValidator;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.OtherNodeTypeRelationFilter;
import org.structr.core.entity.Relation;
import org.structr.core.graph.NodeInterface;
import org.structr.core.notion.Notion;
import org.structr.core.property.ArrayProperty;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.DateProperty;
import org.structr.core.property.DoubleProperty;
import org.structr.core.property.EndNode;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.IntProperty;
import org.structr.core.property.LongProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.RelationProperty;
import org.structr.core.property.StartNode;
import org.structr.core.property.StringProperty;
import org.structr.core.validator.TypeValidator;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.exception.NotFoundException;
import org.structr.rest.resource.Resource;
import org.structr.rest.resource.SortableResource;
import org.structr.rest.resource.TypeResource;
import org.structr.rest.resource.TypedIdResource;

public class StaticRelationshipResource
extends SortableResource {
    private static final Logger logger = Logger.getLogger(StaticRelationshipResource.class.getName());
    TypeResource typeResource = null;
    TypedIdResource typedIdResource = null;
    PropertyKey propertyKey = null;

    public StaticRelationshipResource(SecurityContext securityContext, TypedIdResource typedIdResource, TypeResource typeResource) {
        this.securityContext = securityContext;
        this.typedIdResource = typedIdResource;
        this.typeResource = typeResource;
        this.propertyKey = this.findPropertyKey(typedIdResource, typeResource);
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        GraphObject sourceEntity = this.typedIdResource.getEntity();
        if (sourceEntity != null) {
            if (this.propertyKey == null) {
                if (sourceEntity instanceof NodeInterface) {
                    if (!this.typeResource.isNode) {
                        NodeInterface source = (NodeInterface)sourceEntity;
                        Node sourceNode = source.getNode();
                        Class relationshipType = this.typeResource.entityClass;
                        Relation relation = AbstractNode.getRelationshipForType((Class)relationshipType);
                        Class destNodeType = relation.getOtherType(this.typedIdResource.getEntityClass());
                        LinkedHashSet partialResult = new LinkedHashSet(this.typeResource.doGet(sortKey, sortDescending, Integer.MAX_VALUE, 1, null).getResults());
                        Set set = Iterables.toSet((Iterable)Iterables.filter((Predicate)new OtherNodeTypeRelationFilter(this.securityContext, sourceNode, destNodeType), (Iterable)source.getRelationships(relationshipType)));
                        set.retainAll(partialResult);
                        LinkedList finalResult = new LinkedList(set);
                        this.applyDefaultSorting(finalResult, sortKey, sortDescending);
                        return new Result(PagingHelper.subList(finalResult, (int)pageSize, (int)page, (String)offsetId), Integer.valueOf(finalResult.size()), this.isCollectionResource(), this.isPrimitiveArray());
                    }
                    throw new NotFoundException("Cannot access relationship collection " + this.typeResource.getRawType());
                }
            } else {
                Query query = this.typeResource.query;
                if (query == null) {
                    query = StructrApp.getInstance((SecurityContext)this.securityContext).nodeQuery();
                }
                this.typeResource.collectSearchAttributes(query);
                Predicate predicate = query.toPredicate();
                Object value = sourceEntity.getProperty(this.propertyKey, predicate);
                if (value != null) {
                    if (value instanceof Iterable) {
                        LinkedHashSet propertyResults = new LinkedHashSet();
                        Iterator iter = ((Iterable)value).iterator();
                        boolean iterableContainsGraphObject = false;
                        while (iter.hasNext()) {
                            Object obj = iter.next();
                            propertyResults.add(obj);
                            if (obj == null || iterableContainsGraphObject || !(obj instanceof GraphObject)) continue;
                            iterableContainsGraphObject = true;
                        }
                        int rawResultCount = propertyResults.size();
                        if (!iterableContainsGraphObject) {
                            GraphObjectMap gObject = new GraphObjectMap();
                            gObject.setProperty((PropertyKey)new ArrayProperty(this.typeResource.rawType, Object.class, new PropertyValidator[]{new TypeValidator(Object.class)}), (Object)propertyResults.toArray());
                            Result r = new Result((GraphObject)gObject, true);
                            r.setRawResultCount(Integer.valueOf(rawResultCount));
                            return r;
                        }
                        LinkedList finalResult = new LinkedList();
                        propertyResults.forEach(v -> finalResult.add((GraphObject)v));
                        this.applyDefaultSorting(finalResult, sortKey, sortDescending);
                        Result r = new Result(PagingHelper.subList(finalResult, (int)pageSize, (int)page, (String)offsetId), Integer.valueOf(finalResult.size()), this.isCollectionResource(), this.isPrimitiveArray());
                        r.setRawResultCount(Integer.valueOf(rawResultCount));
                        return r;
                    }
                    if (value instanceof GraphObject) {
                        return new Result((GraphObject)value, this.isPrimitiveArray());
                    }
                    if (value != null) {
                        StringProperty key;
                        GraphObjectMap gObject = new GraphObjectMap();
                        String keyName = this.typeResource.rawType;
                        int resultCount = 1;
                        if (value instanceof String) {
                            key = new StringProperty(keyName);
                        } else if (value instanceof Integer) {
                            key = new IntProperty(keyName);
                        } else if (value instanceof Long) {
                            key = new LongProperty(keyName);
                        } else if (value instanceof Double) {
                            key = new DoubleProperty(keyName);
                        } else if (value instanceof Boolean) {
                            key = new BooleanProperty(keyName);
                        } else if (value instanceof Date) {
                            key = new DateProperty(keyName);
                        } else if (value instanceof String[]) {
                            key = new ArrayProperty(keyName, String.class, new PropertyValidator[]{new TypeValidator(String.class)});
                            resultCount = ((String[])value).length;
                        } else {
                            key = new GenericProperty(keyName);
                        }
                        gObject.setProperty((PropertyKey)key, value);
                        Result r = new Result((GraphObject)gObject, true);
                        r.setRawResultCount(Integer.valueOf(resultCount));
                        return r;
                    }
                    logger.log(Level.INFO, "Found object {0}, but will not return as it is no graph object or iterable", value);
                }
                if (!(this.propertyKey instanceof StartNode) && !(this.propertyKey instanceof EndNode)) {
                    return new Result(Collections.EMPTY_LIST, Integer.valueOf(1), false, true);
                }
            }
        }
        return new Result(Collections.EMPTY_LIST, Integer.valueOf(0), false, true);
    }

    @Override
    public RestMethodResult doPut(Map<String, Object> propertySet) throws FrameworkException {
        GraphObject sourceEntity;
        List results = this.typedIdResource.doGet(null, false, Integer.MAX_VALUE, 1, null).getResults();
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        if (results != null && this.propertyKey != null && this.propertyKey instanceof RelationProperty && (sourceEntity = this.typedIdResource.getEntity()) != null) {
            if (this.propertyKey.isReadOnly()) {
                logger.log(Level.INFO, "Read-only property on {1}: {0}", new Object[]{sourceEntity.getClass(), this.typeResource.getRawType()});
                return new RestMethodResult(403);
            }
            LinkedList<NodeInterface> nodes = new LinkedList<NodeInterface>();
            for (Object obj : propertySet.values()) {
                nodes.add(app.getNodeById(obj.toString()));
            }
            sourceEntity.setProperty(this.propertyKey, nodes);
        }
        return new RestMethodResult(200);
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        GraphObject sourceNode = this.typedIdResource.getEntity();
        if (sourceNode != null && this.propertyKey != null && this.propertyKey instanceof RelationProperty) {
            RelationProperty relationProperty = (RelationProperty)this.propertyKey;
            Class<?> sourceNodeType = sourceNode.getClass();
            NodeInterface newNode = null;
            if (this.propertyKey.isReadOnly()) {
                logger.log(Level.INFO, "Read-only property on {0}: {1}", new Object[]{sourceNodeType, this.typeResource.getRawType()});
                return null;
            }
            Notion notion = relationProperty.getNotion();
            PropertyKey primaryPropertyKey = notion.getPrimaryPropertyKey();
            if (!(primaryPropertyKey != null && propertySet.containsKey(primaryPropertyKey.jsonName()) && propertySet.size() == 1 || (newNode = this.typeResource.createNode(propertySet)) == null)) {
                relationProperty.addSingleElement(this.securityContext, sourceNode, (Object)newNode);
            }
            if (newNode != null) {
                RestMethodResult result = new RestMethodResult(201);
                result.addHeader("Location", this.buildLocationHeader((GraphObject)newNode));
                return result;
            }
        } else {
            GraphObject entity = this.typedIdResource.getIdResource().getEntity();
            Class entityType = this.typedIdResource.getEntityClass();
            String methodName = this.typeResource.getRawType();
            if (entity != null && entityType != null && methodName != null) {
                Object obj = entity.invokeMethod(methodName, propertySet, true);
                if (obj instanceof RestMethodResult) {
                    return (RestMethodResult)obj;
                }
                RestMethodResult result = new RestMethodResult(200);
                this.unwrapTo(obj, result);
                return result;
            }
        }
        throw new IllegalPathException("Illegal path");
    }

    private void unwrapTo(Object source, RestMethodResult result) {
        if (source != null) {
            Object unwrapped = Context.jsToJava((Object)source, (Class)ScriptRuntime.ObjectClass);
            if (unwrapped.getClass().isArray()) {
                for (Object element : (Object[])unwrapped) {
                    this.unwrapTo(element, result);
                }
            } else if (unwrapped instanceof Collection) {
                for (Object element : (Collection)unwrapped) {
                    this.unwrapTo(element, result);
                }
            } else if (unwrapped instanceof GraphObject) {
                result.addContent((GraphObject)unwrapped);
            }
        }
    }

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) {
        return false;
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        if (next instanceof TypeResource) {
            throw new IllegalPathException("Unable to resolve URL path, no type resource expected here");
        }
        return super.tryCombineWith(next);
    }

    @Override
    public Class getEntityClass() {
        Class type = this.typeResource.getEntityClass();
        if (type == null && this.propertyKey != null) {
            return this.propertyKey.relatedType();
        }
        return type;
    }

    @Override
    public String getUriPart() {
        return this.typedIdResource.getUriPart().concat("/").concat(this.typeResource.getUriPart());
    }

    public TypedIdResource getTypedIdConstraint() {
        return this.typedIdResource;
    }

    public TypeResource getTypeConstraint() {
        return this.typeResource;
    }

    @Override
    public boolean isCollectionResource() {
        return true;
    }

    @Override
    public String getResourceSignature() {
        return this.typedIdResource.getResourceSignature().concat("/").concat(this.typeResource.getResourceSignature());
    }
}

