/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.auth;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.auth.exception.AuthenticationException;
import org.structr.core.entity.AbstractUser;
import org.structr.core.entity.Principal;
import org.structr.core.entity.SuperUser;
import org.structr.core.property.PropertyKey;
import org.structr.rest.auth.SessionHelper;
import org.structr.schema.action.Actions;

public class AuthHelper {
    public static final String STANDARD_ERROR_MSG = "Wrong username or password, or user is blocked. Check caps lock. Note: Username is case sensitive!";
    private static final Logger logger = Logger.getLogger(AuthHelper.class.getName());

    public static <T> Principal getPrincipalForCredential(PropertyKey<T> key, T value) {
        if (value != null) {
            try {
                return (Principal)StructrApp.getInstance().nodeQuery(Principal.class).and(key, value).getFirst();
            }
            catch (FrameworkException fex) {
                logger.log(Level.WARNING, "Error while searching for principal", fex);
            }
        }
        return null;
    }

    public static Principal getPrincipalForPassword(PropertyKey<String> key, String value, String password) throws AuthenticationException {
        String errorMsg = null;
        SuperUser principal = null;
        String superuserName = StructrApp.getConfigurationValue((String)"superuser.username");
        String superUserPwd = StructrApp.getConfigurationValue((String)"superuser.password");
        if (superuserName.equals(value) && superUserPwd.equals(password)) {
            principal = new SuperUser();
        } else {
            try {
                principal = (Principal)StructrApp.getInstance().nodeQuery(Principal.class).and().or(key, (Object)value).or((PropertyKey)AbstractUser.name, (Object)value).getFirst();
                if (principal == null) {
                    logger.log(Level.INFO, "No principal found for {0} {1}", new Object[]{key.dbName(), value});
                    errorMsg = STANDARD_ERROR_MSG;
                } else {
                    if (((Boolean)principal.getProperty((PropertyKey)Principal.blocked)).booleanValue()) {
                        logger.log(Level.INFO, "Principal {0} is blocked", principal);
                        errorMsg = STANDARD_ERROR_MSG;
                    }
                    if (StringUtils.isEmpty((CharSequence)password)) {
                        logger.log(Level.INFO, "Empty password for principal {0}", principal);
                        errorMsg = "Empty password, should never happen here!";
                    } else if (!principal.isValidPassword(password)) {
                        errorMsg = STANDARD_ERROR_MSG;
                    }
                }
            }
            catch (FrameworkException fex) {
                logger.log(Level.WARNING, "", fex);
            }
        }
        if (errorMsg != null) {
            throw new AuthenticationException(errorMsg);
        }
        return principal;
    }

    public static Principal getPrincipalForSessionId(String sessionId) {
        return AuthHelper.getPrincipalForCredential(Principal.sessionIds, new String[]{sessionId});
    }

    public static void doLogin(HttpServletRequest request, Principal user) throws FrameworkException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            session = SessionHelper.newSession(request);
        }
        SessionHelper.clearInvalidSessions(user);
        if (session != null) {
            SessionHelper.clearSession(session.getId());
            user.addSessionId(session.getId());
            Actions.call((String)"onStructrLogin", (Principal)user);
        }
    }

    public static void doLogout(HttpServletRequest request, Principal user) throws FrameworkException {
        HttpSession session = request.getSession(false);
        SessionHelper.clearSession(session.getId());
        SessionHelper.invalidateSession(session);
        AuthHelper.sendLogoutNotification(user);
        try {
            request.logout();
            request.changeSessionId();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void sendLogoutNotification(Principal user) throws FrameworkException {
        Actions.call((String)"onStructrLogout", (Principal)user);
    }
}

