/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.structr.core.GraphObject;
import org.structr.core.Result;

public class RestMethodResult {
    private static final Logger logger = Logger.getLogger(RestMethodResult.class.getName());
    private List<GraphObject> content = null;
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private int responseCode = 0;
    private String message = null;
    private boolean serializeSingleObjectAsCollection = false;
    private boolean serializeAsPrimitiveArray = false;

    public RestMethodResult(int responseCode) {
        this.responseCode = responseCode;
    }

    public RestMethodResult(int responseCode, String message) {
        this.message = message;
        this.responseCode = responseCode;
    }

    public RestMethodResult(int responseCode, boolean serializeSingleObjectAsCollection) {
        this.responseCode = responseCode;
        this.serializeSingleObjectAsCollection = serializeSingleObjectAsCollection;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addContent(GraphObject graphObject) {
        if (this.content == null) {
            this.content = new LinkedList<GraphObject>();
        }
        this.content.add(graphObject);
    }

    public void commitResponse(Gson gson, HttpServletResponse response) {
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            response.setHeader(header.getKey(), header.getValue());
        }
        response.setStatus(this.responseCode);
        try {
            PrintWriter writer = response.getWriter();
            if (this.content != null) {
                Result result = new Result(this.content, Integer.valueOf(this.content.size()), this.content.size() > 1 || this.serializeSingleObjectAsCollection, this.serializeAsPrimitiveArray);
                gson.toJson((Object)result, (Appendable)writer);
            }
            if (this.content == null) {
                ((Writer)writer).append(RestMethodResult.jsonMessage(this.responseCode, this.message));
            }
            ((Writer)writer).append("\n");
        }
        catch (JsonIOException | IOException t) {
            logger.log(Level.WARNING, "Unable to commit HttpServletResponse", t);
        }
    }

    public void serializeAsPrimitiveArray(boolean value) {
        this.serializeAsPrimitiveArray = value;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<GraphObject> getContent() {
        return this.content;
    }

    public static String jsonError(int code, String message) {
        return RestMethodResult.jsonMessage(code, message, "error");
    }

    public static String jsonMessage(int code, String message) {
        return RestMethodResult.jsonMessage(code, message, "message");
    }

    public static String jsonMessage(int code, String message, String messageKey) {
        StringBuilder buf = new StringBuilder(100);
        buf.append("{\n");
        buf.append("  \"code\" : ").append(code);
        if (message != null) {
            buf.append(",\n  \"").append(messageKey).append("\" : \"").append(StringUtils.replace((String)message, (String)"\"", (String)"\\\"")).append("\"\n");
        } else {
            buf.append("\n");
        }
        buf.append("}\n");
        return buf.toString();
    }
}

