/*
 * Decompiled with CFR 0.152.
 */
package org.standardout.gradle.plugin.platform.internal.osdetect;

import java.util.Locale;
import org.standardout.gradle.plugin.platform.internal.osdetect.Arch;

public enum OS {
    WIN_x64,
    WIN_x86,
    LINUX_x64,
    LINUX_x86,
    MAC_x64;

    private static final OS NATIVE_OS;
    private static final OS RUNNING_OS;

    public boolean isWindows() {
        return this == WIN_x64 || this == WIN_x86;
    }

    public boolean isLinux() {
        return this == LINUX_x64 || this == LINUX_x86;
    }

    public boolean isMac() {
        return this == MAC_x64;
    }

    public boolean isMacOrLinux() {
        return this.isMac() || this.isLinux();
    }

    public <T> T winMacLinux(T win, T mac, T linux) {
        if (this.isWindows()) {
            return win;
        }
        if (this.isMac()) {
            return mac;
        }
        if (this.isLinux()) {
            return linux;
        }
        throw OS.unsupportedException(this);
    }

    public Arch getArch() {
        switch (this) {
            case WIN_x64: 
            case LINUX_x64: 
            case MAC_x64: {
                return Arch.x64;
            }
            case WIN_x86: 
            case LINUX_x86: {
                return Arch.x86;
            }
        }
        throw OS.unsupportedException(this);
    }

    public static OS getNative() {
        return NATIVE_OS;
    }

    public static OS getRunning() {
        return RUNNING_OS;
    }

    private static OS calculateNative() {
        boolean isLinux;
        String os_name = System.getProperty("os.name").toLowerCase(Locale.getDefault());
        boolean isWin = os_name.contains("win");
        boolean isMac = os_name.contains("mac");
        boolean bl = isLinux = os_name.contains("nix") || os_name.contains("nux") || os_name.contains("aix");
        if (isMac) {
            return MAC_x64;
        }
        if (isWin) {
            boolean is64bit = System.getenv("ProgramFiles(x86)") != null;
            return is64bit ? WIN_x64 : WIN_x86;
        }
        if (isLinux) {
            String os_arch;
            switch (os_arch = System.getProperty("os.arch")) {
                case "i386": 
                case "x86": {
                    return LINUX_x86;
                }
                case "x86_64": 
                case "amd64": {
                    return LINUX_x64;
                }
            }
            throw new IllegalArgumentException("Unknown os.arch " + os_arch + "'.");
        }
        throw new IllegalArgumentException("Unknown os.name '" + os_name + "'.");
    }

    private static OS calculateRunning() {
        Arch runningArch = OS.runningJvm();
        return NATIVE_OS.winMacLinux(runningArch.x86x64(WIN_x86, WIN_x64), MAC_x64, runningArch.x86x64(LINUX_x86, LINUX_x64));
    }

    private static Arch runningJvm() {
        String sunArchDataModel;
        switch (sunArchDataModel = System.getProperty("sun.arch.data.model")) {
            case "32": {
                return Arch.x86;
            }
            case "64": {
                return Arch.x64;
            }
        }
        throw new IllegalArgumentException(sunArchDataModel);
    }

    public static UnsupportedOperationException unsupportedException(OS os) {
        return new UnsupportedOperationException("Operating system '" + (Object)((Object)os) + "' is not supported.");
    }

    static {
        NATIVE_OS = OS.calculateNative();
        RUNNING_OS = OS.calculateRunning();
    }
}

