/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.servlet;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.ssssssss.magicapi.core.annotation.MagicModule;
import org.ssssssss.magicapi.utils.IpUtils;
import org.ssssssss.magicapi.utils.WebUtils;
import org.ssssssss.script.annotation.Comment;

@MagicModule(value="request")
public class RequestModule {
    private static MultipartResolver resolver;
    private static final String[] DEFAULT_IP_HEADER;

    public RequestModule(MultipartResolver resolver) {
        RequestModule.resolver = resolver;
    }

    @Comment(value="\u83b7\u53d6\u6587\u4ef6")
    public static MultipartFile getFile(@Comment(name="name", value="\u53c2\u6570\u540d") String name) {
        MultipartRequest request = RequestModule.getMultipartHttpServletRequest();
        if (request == null) {
            return null;
        }
        MultipartFile file = request.getFile(name);
        return file == null || file.isEmpty() ? null : file;
    }

    @Comment(value="\u83b7\u53d6\u591a\u4e2a\u6587\u4ef6")
    public static List<MultipartFile> getFiles(@Comment(name="name", value="\u53c2\u6570\u540d") String name) {
        MultipartRequest request = RequestModule.getMultipartHttpServletRequest();
        if (request == null) {
            return null;
        }
        return request.getFiles(name).stream().filter(it -> !it.isEmpty()).collect(Collectors.toList());
    }

    @Comment(value="\u83b7\u53d6\u539f\u751fHttpServletRequest\u5bf9\u8c61")
    public static HttpServletRequest get() {
        return WebUtils.getRequest().orElse(null);
    }

    private static MultipartRequest getMultipartHttpServletRequest() {
        HttpServletRequest request = RequestModule.get();
        if (request != null && resolver.isMultipart(request)) {
            return resolver.resolveMultipart(request);
        }
        return null;
    }

    @Comment(value="\u6839\u636e\u8bf7\u6c42\u53c2\u6570\u540d\u83b7\u53d6\u503c")
    public List<String> getValues(@Comment(name="name", value="\u53c2\u6570\u540d") String name) {
        HttpServletRequest request = RequestModule.get();
        if (request != null) {
            String[] values = request.getParameterValues(name);
            return values == null ? null : Arrays.asList(values);
        }
        return null;
    }

    @Comment(value="\u6839\u636eheader\u540d\u83b7\u53d6\u503c")
    public List<String> getHeaders(@Comment(name="name", value="header\u540d") String name) {
        HttpServletRequest request = RequestModule.get();
        if (request != null) {
            Enumeration headers = request.getHeaders(name);
            return headers == null ? null : Collections.list(headers);
        }
        return null;
    }

    @Comment(value="\u83b7\u53d6\u5ba2\u6237\u7aefIP")
    public String getClientIP(String ... otherHeaderNames) {
        HttpServletRequest request = RequestModule.get();
        if (request == null) {
            return null;
        }
        return IpUtils.getRealIP(request.getRemoteAddr(), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0), otherHeaderNames);
    }

    static {
        DEFAULT_IP_HEADER = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
    }
}

