/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.web;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.backup.service.MagicBackupService;
import org.ssssssss.magicapi.core.annotation.Valid;
import org.ssssssss.magicapi.core.config.JsonCodeConstants;
import org.ssssssss.magicapi.core.config.MagicConfiguration;
import org.ssssssss.magicapi.core.context.MagicUser;
import org.ssssssss.magicapi.core.exception.InvalidArgumentException;
import org.ssssssss.magicapi.core.exception.MagicLoginException;
import org.ssssssss.magicapi.core.interceptor.Authorization;
import org.ssssssss.magicapi.core.model.Group;
import org.ssssssss.magicapi.core.model.JsonBean;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.core.service.MagicAPIService;
import org.ssssssss.magicapi.core.service.MagicResourceService;

public class MagicController
implements JsonCodeConstants {
    final MagicAPIService magicAPIService;
    final MagicBackupService magicBackupService;
    protected MagicConfiguration configuration;

    public MagicController(MagicConfiguration configuration) {
        this.configuration = configuration;
        this.magicAPIService = configuration.getMagicAPIService();
        this.magicBackupService = configuration.getMagicBackupService();
    }

    public void doValid(HttpServletRequest request, Valid valid) {
        if (valid != null) {
            if (!valid.readonly() && this.configuration.getWorkspace().readonly()) {
                throw new InvalidArgumentException(IS_READ_ONLY);
            }
            if (valid.authorization() != Authorization.NONE && !this.allowVisit(request, valid.authorization())) {
                throw new InvalidArgumentException(PERMISSION_INVALID);
            }
        }
    }

    boolean allowVisit(HttpServletRequest request, Authorization authorization) {
        if (authorization == null) {
            return true;
        }
        MagicUser magicUser = (MagicUser)request.getAttribute("MAGIC_API_ATTRIBUTE_USER");
        return this.configuration.getAuthorizationInterceptor().allowVisit(magicUser, request, authorization);
    }

    boolean allowVisit(HttpServletRequest request, Authorization authorization, MagicEntity entity) {
        if (authorization == null) {
            return true;
        }
        MagicUser magicUser = (MagicUser)request.getAttribute("MAGIC_API_ATTRIBUTE_USER");
        return this.configuration.getAuthorizationInterceptor().allowVisit(magicUser, request, authorization, entity);
    }

    boolean allowVisit(HttpServletRequest request, Authorization authorization, Group group) {
        if (authorization == null) {
            return true;
        }
        MagicUser magicUser = (MagicUser)request.getAttribute("MAGIC_API_ATTRIBUTE_USER");
        return this.configuration.getAuthorizationInterceptor().allowVisit(magicUser, request, authorization, group);
    }

    List<MagicEntity> entities(HttpServletRequest request, Authorization authorization) {
        MagicController magicController = this;
        MagicResourceService service = magicController.configuration.getMagicResourceService();
        return service.tree().values().stream().flatMap(it -> it.flat().stream()).filter(it -> !"0".equals(it.getId())).filter(it -> this.allowVisit(request, authorization, (Group)it)).flatMap(it -> service.listFiles(it.getId()).stream()).filter(it -> this.allowVisit(request, authorization, (MagicEntity)it)).filter(it -> Objects.nonNull(it.getScript())).collect(Collectors.toList());
    }

    @ExceptionHandler(value={MagicLoginException.class})
    @ResponseBody
    public JsonBean<Void> invalidLogin(MagicLoginException exception) {
        return new JsonBean<Void>(401, exception.getMessage());
    }
}

