/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.service.impl;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.ssssssss.magicapi.core.config.JsonCodeConstants;
import org.ssssssss.magicapi.core.config.MagicConfiguration;
import org.ssssssss.magicapi.core.event.FileEvent;
import org.ssssssss.magicapi.core.event.GroupEvent;
import org.ssssssss.magicapi.core.exception.InvalidArgumentException;
import org.ssssssss.magicapi.core.model.ApiInfo;
import org.ssssssss.magicapi.core.service.AbstractMagicDynamicRegistry;
import org.ssssssss.magicapi.core.service.MagicResourceStorage;
import org.ssssssss.magicapi.core.web.RequestHandler;
import org.ssssssss.magicapi.utils.Mapping;
import org.ssssssss.magicapi.utils.PathUtils;
import org.ssssssss.magicapi.utils.ScriptManager;
import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.exception.MagicExitException;
import org.ssssssss.script.runtime.ExitValue;

public class RequestMagicDynamicRegistry
extends AbstractMagicDynamicRegistry<ApiInfo> {
    private final Mapping mapping;
    private Object handler;
    private final Method method = RequestHandler.class.getDeclaredMethod("invoke", HttpServletRequest.class, HttpServletResponse.class, Map.class, Map.class, Map.class);
    private static final Logger logger = LoggerFactory.getLogger(RequestMagicDynamicRegistry.class);
    private final boolean allowOverride;
    private final String prefix;

    public RequestMagicDynamicRegistry(MagicResourceStorage<ApiInfo> magicResourceStorage, Mapping mapping, boolean allowOverride, String prefix) throws NoSuchMethodException {
        super(magicResourceStorage);
        this.mapping = mapping;
        this.allowOverride = allowOverride;
        this.prefix = (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + "/";
        MagicResourceLoader.addFunctionLoader(this::lookupLambdaFunction);
    }

    private Object lookupLambdaFunction(MagicScriptContext context, String name) {
        int index = name.indexOf(":");
        if (index > -1) {
            String method = name.substring(0, index);
            String path = name.substring(index + 1);
            ApiInfo info = (ApiInfo)this.getMapping(method.toUpperCase() + ":" + PathUtils.replaceSlash(this.prefix + path));
            if (info != null) {
                String scriptName = MagicConfiguration.getMagicResourceService().getScriptName(info);
                return (variables, args) -> {
                    MagicScriptContext newContext = new MagicScriptContext();
                    LinkedHashMap varMap = new LinkedHashMap(context.getRootVariables());
                    varMap.putAll(variables.getVariables(context));
                    newContext.setScriptName(scriptName);
                    newContext.putMapIntoContext(varMap);
                    Object value = ScriptManager.executeScript(info.getScript(), newContext);
                    if (value instanceof ExitValue) {
                        throw new MagicExitException((ExitValue)value);
                    }
                    return value;
                };
            }
        }
        return null;
    }

    public void setHandler(Object handler) {
        this.handler = handler;
    }

    @EventListener(condition="#event.type == 'api'")
    public void onFileEvent(FileEvent event) {
        this.processEvent(event);
    }

    @EventListener(condition="#event.type == 'api'")
    public void onGroupEvent(GroupEvent event) {
        this.processEvent(event);
    }

    public ApiInfo getApiInfoFromRequest(HttpServletRequest request) {
        String mappingKey = Objects.toString(request.getMethod(), "GET").toUpperCase() + ":" + request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        return (ApiInfo)this.getMapping(mappingKey);
    }

    @Override
    public boolean register(AbstractMagicDynamicRegistry.MappingNode<ApiInfo> mappingNode) {
        String mappingKey = mappingNode.getMappingKey();
        int index = mappingKey.indexOf(":");
        String requestMethod = mappingKey.substring(0, index);
        String path = mappingKey.substring(index + 1);
        RequestMappingInfo requestMappingInfo = this.mapping.paths(path).methods(new RequestMethod[]{RequestMethod.valueOf((String)requestMethod.toUpperCase())}).build();
        if (this.mapping.getHandlerMethods().containsKey(requestMappingInfo)) {
            if (!this.allowOverride) {
                logger.error("\u63a5\u53e3[{}({})]\u4e0e\u5e94\u7528\u51b2\u7a81\uff0c\u65e0\u6cd5\u6ce8\u518c", (Object)mappingNode.getEntity().getName(), (Object)mappingKey);
                throw new InvalidArgumentException(JsonCodeConstants.REQUEST_PATH_CONFLICT.format(mappingNode.getEntity().getName(), mappingKey));
            }
            logger.warn("\u53d6\u6d88\u6ce8\u518c\u5e94\u7528\u63a5\u53e3:{}", (Object)requestMappingInfo);
            this.mapping.unregister(requestMappingInfo);
        }
        logger.debug("\u6ce8\u518c\u63a5\u53e3[{}({})]", (Object)mappingNode.getEntity().getName(), (Object)mappingKey);
        this.mapping.register(requestMappingInfo, this.handler, this.method);
        mappingNode.setMappingData(requestMappingInfo);
        return true;
    }

    @Override
    protected void unregister(AbstractMagicDynamicRegistry.MappingNode<ApiInfo> mappingNode) {
        logger.debug("\u53d6\u6d88\u6ce8\u518c\u63a5\u53e3[{}({})]", (Object)mappingNode.getEntity().getName(), (Object)mappingNode.getMappingKey());
        this.mapping.unregister((RequestMappingInfo)mappingNode.getMappingData());
    }
}

