/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.model;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ssssssss.magicapi.core.config.MagicConfiguration;
import org.ssssssss.magicapi.core.model.BaseDefinition;
import org.ssssssss.magicapi.core.model.Header;
import org.ssssssss.magicapi.core.model.Option;
import org.ssssssss.magicapi.core.model.Options;
import org.ssssssss.magicapi.core.model.Parameter;
import org.ssssssss.magicapi.core.model.Path;
import org.ssssssss.magicapi.core.model.PathMagicEntity;
import org.ssssssss.magicapi.utils.JsonUtils;

public class ApiInfo
extends PathMagicEntity {
    private String method = "GET";
    private List<Parameter> parameters = Collections.emptyList();
    private List<Option> options = new ArrayList<Option>();
    private String requestBody;
    private List<Header> headers = Collections.emptyList();
    private List<Path> paths = Collections.emptyList();
    private String responseBody;
    private String description;
    private BaseDefinition requestBodyDefinition;
    private BaseDefinition responseBodyDefinition;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    public void setPaths(List<Path> paths) {
        this.paths = paths;
    }

    public Map<String, String> options() {
        Map<String, String> map = this.options.stream().collect(Collectors.toMap(BaseDefinition::getName, it -> String.valueOf(it.getValue()), (o, n) -> n));
        MagicConfiguration.getMagicResourceService().getGroupsByFileId(this.groupId).stream().flatMap(it -> it.getOptions().stream()).forEach(option -> {
            if (!map.containsKey(option.getName())) {
                map.put(option.getName(), String.valueOf(option.getValue()));
            }
        });
        return map;
    }

    public void setOptionMap(Map<String, Object> optionMap) {
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void setOption(List<Option> options) {
        this.options = options;
    }

    public void setOption(String json) {
        this.options = JsonUtils.readValue(Objects.toString(json, "[]"), new TypeReference<List<Option>>(){});
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public String getOptionValue(Options options) {
        return this.getOptionValue(options.getValue());
    }

    public String getOptionValue(String key) {
        return this.options.stream().filter(it -> key.equals(it.getName())).findFirst().map(it -> Objects.toString(it.getValue(), null)).orElseGet(() -> MagicConfiguration.getMagicResourceService().getGroupsByFileId(this.id).stream().flatMap(it -> it.getOptions().stream()).filter(it -> key.equals(it.getName())).findFirst().map(it -> Objects.toString(it.getValue(), null)).orElse(null));
    }

    public BaseDefinition getRequestBodyDefinition() {
        return this.requestBodyDefinition;
    }

    public void setRequestBodyDefinition(BaseDefinition requestBodyDefinition) {
        this.requestBodyDefinition = requestBodyDefinition;
    }

    public BaseDefinition getResponseBodyDefinition() {
        return this.responseBodyDefinition;
    }

    public void setResponseBodyDefinition(BaseDefinition responseBodyDefinition) {
        this.responseBodyDefinition = responseBodyDefinition;
    }

    @Override
    public ApiInfo simple() {
        ApiInfo target = new ApiInfo();
        super.simple(target);
        target.setMethod(this.getMethod());
        return target;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiInfo apiInfo = (ApiInfo)o;
        return Objects.equals(this.id, apiInfo.id) && Objects.equals(this.method, apiInfo.method) && Objects.equals(this.path, apiInfo.path) && Objects.equals(this.script, apiInfo.script) && Objects.equals(this.name, apiInfo.name) && Objects.equals(this.paths, apiInfo.paths) && Objects.equals(this.groupId, apiInfo.groupId) && Objects.equals(this.parameters, apiInfo.parameters) && Objects.equals(this.options, apiInfo.options) && Objects.equals(this.requestBody, apiInfo.requestBody) && Objects.equals(this.headers, apiInfo.headers) && Objects.equals(this.description, apiInfo.description) && Objects.equals(this.requestBodyDefinition, apiInfo.requestBodyDefinition) && Objects.equals(this.responseBodyDefinition, apiInfo.responseBodyDefinition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.method, this.path, this.script, this.name, this.groupId, this.parameters, this.options, this.requestBody, this.headers, this.description, this.requestBodyDefinition, this.responseBodyDefinition);
    }

    @Override
    public ApiInfo copy() {
        ApiInfo info = new ApiInfo();
        this.copyTo(info);
        info.setMethod(this.method);
        info.setParameters(this.parameters);
        info.setRequestBody(this.requestBody);
        info.setOption(this.options);
        info.setHeaders(this.headers);
        info.setResponseBody(this.responseBody);
        info.setDescription(this.description);
        info.setPaths(this.paths);
        info.setRequestBodyDefinition(this.requestBodyDefinition);
        info.setResponseBodyDefinition(this.responseBodyDefinition);
        return info;
    }
}

