/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.ssssssss.magicapi.core.annotation.Valid;
import org.ssssssss.magicapi.core.config.MagicCorsFilter;
import org.ssssssss.magicapi.core.exception.MagicLoginException;
import org.ssssssss.magicapi.core.interceptor.AuthorizationInterceptor;
import org.ssssssss.magicapi.core.web.MagicController;

public class MagicWebRequestInterceptor
implements HandlerInterceptor {
    private final MagicCorsFilter magicCorsFilter;
    private final AuthorizationInterceptor authorizationInterceptor;

    public MagicWebRequestInterceptor(MagicCorsFilter magicCorsFilter, AuthorizationInterceptor authorizationInterceptor) {
        this.magicCorsFilter = magicCorsFilter;
        this.authorizationInterceptor = authorizationInterceptor;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws MagicLoginException {
        HandlerMethod handlerMethod;
        if (handler instanceof HandlerMethod && (handler = (handlerMethod = (HandlerMethod)handler).getBean()) instanceof MagicController) {
            boolean validRequiredLogin;
            if (this.magicCorsFilter != null) {
                this.magicCorsFilter.process(request, response);
            }
            Valid valid = (Valid)handlerMethod.getMethodAnnotation(Valid.class);
            boolean requiredLogin = this.authorizationInterceptor.requireLogin();
            boolean bl = validRequiredLogin = valid == null || valid.requireLogin();
            if (requiredLogin && validRequiredLogin) {
                request.setAttribute("MAGIC_API_ATTRIBUTE_USER", (Object)this.authorizationInterceptor.getUserByToken(request.getHeader("Magic-Token")));
            }
            ((MagicController)handler).doValid(request, valid);
        }
        return true;
    }
}

