/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.spring.boot.starter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.ssssssss.magicapi.config.MappingHandlerMapping;
import org.ssssssss.magicapi.provider.GroupServiceProvider;
import org.ssssssss.magicapi.spring.boot.starter.MagicAPIAutoConfiguration;
import org.ssssssss.magicapi.spring.boot.starter.MagicAPIProperties;
import org.ssssssss.magicapi.spring.boot.starter.SwaggerConfig;
import org.ssssssss.magicapi.swagger.SwaggerEntity;
import org.ssssssss.magicapi.swagger.SwaggerProvider;
import org.ssssssss.magicapi.utils.Mapping;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Configuration
@AutoConfigureAfter(value={MagicAPIAutoConfiguration.class})
@EnableConfigurationProperties(value={MagicAPIProperties.class})
@ConditionalOnClass(name={"springfox.documentation.swagger.web.SwaggerResourcesProvider"})
public class MagicSwaggerConfiguration {
    private final MagicAPIProperties properties;
    private final ApplicationContext applicationContext;
    @Autowired
    @Lazy
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    public MagicSwaggerConfiguration(MagicAPIProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }

    @Bean
    @Primary
    public SwaggerResourcesProvider magicSwaggerResourcesProvider(MappingHandlerMapping handlerMapping, GroupServiceProvider groupServiceProvider, ServletContext servletContext) throws NoSuchMethodException {
        SwaggerConfig config = this.properties.getSwaggerConfig();
        Mapping mapping = Mapping.create((RequestMappingHandlerMapping)this.requestMappingHandlerMapping);
        RequestMappingInfo requestMappingInfo = mapping.paths(new String[]{config.getLocation()}).build();
        SwaggerProvider swaggerProvider = new SwaggerProvider();
        swaggerProvider.setGroupServiceProvider(groupServiceProvider);
        swaggerProvider.setMappingHandlerMapping(handlerMapping);
        swaggerProvider.setPersistenceResponseBody(this.properties.isPersistenceResponseBody());
        SwaggerEntity.License license = new SwaggerEntity.License("MIT", "https://gitee.com/ssssssss-team/magic-api/blob/master/LICENSE");
        swaggerProvider.setInfo(new SwaggerEntity.Info(config.getDescription(), config.getVersion(), config.getTitle(), license, config.getConcat()));
        swaggerProvider.setBasePath(servletContext.getContextPath());
        mapping.register(requestMappingInfo, (Object)swaggerProvider, SwaggerProvider.class.getDeclaredMethod("swaggerJson", new Class[0]));
        return () -> {
            ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
            resources.add(this.swaggerResource(config.getName(), config.getLocation()));
            Map beans = this.applicationContext.getBeansOfType(SwaggerResourcesProvider.class);
            for (Map.Entry entry : beans.entrySet()) {
                if ("magicSwaggerResourcesProvider".equalsIgnoreCase((String)entry.getKey())) continue;
                resources.addAll((Collection)((SwaggerResourcesProvider)entry.getValue()).get());
            }
            return resources;
        };
    }

    private SwaggerResource swaggerResource(String name, String location) {
        SwaggerResource resource = new SwaggerResource();
        resource.setName(name);
        resource.setLocation(location);
        resource.setSwaggerVersion("2.0");
        return resource;
    }
}

