/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.spring.boot.starter;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.ssssssss.magicapi.adapter.Resource;
import org.ssssssss.magicapi.adapter.resource.RedisResource;
import org.ssssssss.magicapi.model.MagicNotify;
import org.ssssssss.magicapi.modules.RedisModule;
import org.ssssssss.magicapi.provider.MagicAPIService;
import org.ssssssss.magicapi.provider.MagicNotifyService;
import org.ssssssss.magicapi.spring.boot.starter.ClusterConfig;
import org.ssssssss.magicapi.spring.boot.starter.MagicAPIAutoConfiguration;
import org.ssssssss.magicapi.spring.boot.starter.MagicAPIProperties;
import org.ssssssss.magicapi.spring.boot.starter.ResourceConfig;
import org.ssssssss.magicapi.utils.JsonUtils;

@ConditionalOnClass(value={RedisConnectionFactory.class})
@Configuration
@AutoConfigureBefore(value={MagicAPIAutoConfiguration.class})
public class MagicRedisAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MagicRedisAutoConfiguration.class);
    private final MagicAPIProperties properties;
    private final StringRedisTemplate stringRedisTemplate;

    public MagicRedisAutoConfiguration(MagicAPIProperties properties, ObjectProvider<StringRedisTemplate> stringRedisTemplateProvider) {
        this.properties = properties;
        this.stringRedisTemplate = (StringRedisTemplate)stringRedisTemplateProvider.getIfAvailable();
    }

    @Bean
    public RedisModule redisFunctions(RedisConnectionFactory connectionFactory) {
        return new RedisModule(connectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="magic-api", name={"resource.type"}, havingValue="redis")
    public Resource magicRedisResource(RedisConnectionFactory connectionFactory) {
        ResourceConfig resource = this.properties.getResource();
        return new RedisResource(new StringRedisTemplate(connectionFactory), resource.getPrefix(), resource.isReadonly());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="magic-api", name={"cluster-config.enable"}, havingValue="true")
    public MagicNotifyService magicNotifyService() {
        return magicNotify -> this.stringRedisTemplate.convertAndSend(this.properties.getClusterConfig().getChannel(), (Object)Objects.requireNonNull(JsonUtils.toJsonString((Object)magicNotify)));
    }

    @Bean
    @ConditionalOnProperty(prefix="magic-api", name={"cluster-config.enable"}, havingValue="true")
    public RedisMessageListenerContainer magicRedisMessageListenerContainer(RedisConnectionFactory redisConnectionFactory, MagicAPIService magicAPIService) {
        ClusterConfig config = this.properties.getClusterConfig();
        logger.info("\u5f00\u542f\u96c6\u7fa4\u901a\u77e5\u76d1\u542c\uff0c Redis channel: {}", (Object)config.getChannel());
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(redisConnectionFactory);
        redisMessageListenerContainer.addMessageListener((message, pattern) -> magicAPIService.processNotify((MagicNotify)JsonUtils.readValue((byte[])message.getBody(), MagicNotify.class)), (Topic)ChannelTopic.of((String)config.getChannel()));
        return redisMessageListenerContainer;
    }
}

