/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.srplib.validation.ValidationError;

public class ValidationErrors {
    public static final ValidationErrors EMPTY = new ValidationErrors(new ValidationError[0]);
    private List<ValidationError> validationErrors = new LinkedList<ValidationError>();

    public ValidationErrors(List<ValidationError> validationErrors) {
        if (validationErrors == null) {
            throw new IllegalArgumentException("Validation errors list is null");
        }
        this.validationErrors.addAll(validationErrors);
    }

    public ValidationErrors(ValidationError ... errors) {
        this(Arrays.asList(errors));
    }

    public void clear() {
        this.validationErrors.clear();
    }

    public List<ValidationError> getErrors() {
        return Collections.unmodifiableList(this.validationErrors);
    }

    public boolean hasErrors() {
        return !this.validationErrors.isEmpty();
    }

    public void add(ValidationError ... validationError) {
        this.validationErrors.addAll(Arrays.asList(validationError));
    }

    public void add(List<ValidationError> validationErrors) {
        this.validationErrors.addAll(validationErrors);
    }

    public Set<Object> getErrorContexts() {
        HashSet<Object> errorFields = new HashSet<Object>();
        for (ValidationError validationError : this.validationErrors) {
            if (validationError.getContext() == null) continue;
            errorFields.add(validationError.getContext());
        }
        return errorFields;
    }

    public List<ValidationError> getErrorsFor(Object context) {
        LinkedList<ValidationError> fieldErrors = new LinkedList<ValidationError>();
        for (ValidationError validationError : this.validationErrors) {
            if (validationError.getContext() != context) continue;
            fieldErrors.add(validationError);
        }
        return fieldErrors;
    }

    public String toString(String errorSeparator) {
        StringBuilder sb = new StringBuilder();
        for (ValidationError validationError : this.validationErrors) {
            if (validationError.getContext() != null) {
                sb.append(validationError.getContext().toString()).append(": ");
            }
            sb.append(validationError.getError());
            sb.append(errorSeparator);
        }
        return sb.toString();
    }
}

