/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.validation;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.srplib.validation.Validatable;
import org.srplib.validation.ValidationError;

public class DefaultValidatable<T>
implements Validatable<T> {
    private final T value;
    private final Object context;
    private List<ValidationError> errors = new LinkedList<ValidationError>();

    public DefaultValidatable(T value, Object context) {
        this.value = value;
        this.context = context;
    }

    public DefaultValidatable(T value) {
        this(value, null);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public void addError(ValidationError error) {
        this.errors.add(error);
    }

    @Override
    public List<ValidationError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    @Override
    public Object getContext() {
        return this.context;
    }
}

