/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.validation;

import org.srplib.validation.AbstractValidator;
import org.srplib.validation.Validatable;
import org.srplib.validation.ValidationError;
import org.srplib.validation.Validators;

public class ValueRangeValidator<T extends Comparable<T>>
extends AbstractValidator<T> {
    private T lowerLimit;
    private T upperLimit;

    public ValueRangeValidator(T lowerLimit, T upperLimit) {
        if (lowerLimit.compareTo(upperLimit) > 0) {
            throw new IllegalArgumentException("Illegal range specification [" + lowerLimit + ", " + upperLimit + "]");
        }
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    protected boolean isValid(Validatable<T> validatable) {
        Comparable value = (Comparable)validatable.getValue();
        return value.compareTo(this.lowerLimit) >= 0 && value.compareTo(this.upperLimit) <= 0;
    }

    protected ValidationError newError() {
        return Validators.newError("Value is out of range [" + this.lowerLimit + ", " + this.upperLimit + "]");
    }
}

