/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.validation;

import org.srplib.validation.DefaultValidationError;
import org.srplib.validation.EmailAddressValidator;
import org.srplib.validation.PhoneNumberValidator;
import org.srplib.validation.PositiveNumberValidator;
import org.srplib.validation.RegexpValidator;
import org.srplib.validation.StringLengthValidator;
import org.srplib.validation.StringMaxLengthValidator;
import org.srplib.validation.StringMinLengthValidator;
import org.srplib.validation.ValidationError;
import org.srplib.validation.Validator;
import org.srplib.validation.ValueRangeValidator;

public class Validators {
    public static ValidationError newError(String message) {
        return new DefaultValidationError(message);
    }

    public static ValidationError newError(String message, Object formField) {
        return new DefaultValidationError(message, formField);
    }

    public static Validator<String> length(int minimum, int maximum) {
        return new StringLengthValidator(minimum, maximum);
    }

    public static Validator<String> minLength(int minimum) {
        return new StringMinLengthValidator(minimum);
    }

    public static Validator<String> maxLength(int maximum) {
        return new StringMaxLengthValidator(maximum);
    }

    public static Validator<String> regexp(String regexp) {
        return new RegexpValidator(regexp);
    }

    public static Validator<String> email() {
        return new EmailAddressValidator();
    }

    public static Validator<String> phone() {
        return new PhoneNumberValidator();
    }

    public static <T extends Comparable<T>> Validator<T> range(T minimum, T maximum) {
        return new ValueRangeValidator<T>(minimum, maximum);
    }

    public static <T extends Number> Validator<T> positive() {
        return new PositiveNumberValidator();
    }
}

