/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.validation;

import org.srplib.validation.AbstractValidator;
import org.srplib.validation.Validatable;
import org.srplib.validation.ValidationError;
import org.srplib.validation.Validators;

public class StringLengthValidator
extends AbstractValidator<String> {
    private final int minimum;
    private final int maximum;

    public StringLengthValidator(int minimum, int maximum) {
        if (minimum > maximum) {
            throw new IllegalArgumentException("Illegal range specification [" + minimum + ", " + maximum + "]");
        }
        this.minimum = minimum;
        this.maximum = maximum;
    }

    protected int getMinimum() {
        return this.minimum;
    }

    protected int getMaximum() {
        return this.maximum;
    }

    protected boolean isValid(Validatable<String> validatable) {
        String value = (String)validatable.getValue();
        return value.length() >= this.minimum && value.length() <= this.maximum;
    }

    protected ValidationError newError() {
        return Validators.newError("String length should be in range " + this.minimum + " , " + this.maximum + ".");
    }
}

