/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.srplib.contract.Argument;
import org.srplib.contract.Assert;

public class Path {
    private static final String DEFAULT_SEPARATOR = ".";
    public static final Path EMPTY = new Path(Collections.emptyList());
    private final String separator;
    private final List<String> path;

    public static Path empty() {
        return EMPTY;
    }

    public static Path parse(String string, String separator) {
        Argument.checkNotNull((Object)separator, (String)"separator must not be null.", (Object[])new Object[0]);
        if (string == null) {
            return EMPTY;
        }
        String[] segments = string.split(Pattern.quote(separator));
        return new Path(Arrays.asList(segments), separator);
    }

    public static Path parse(String string) {
        return Path.parse(string, DEFAULT_SEPARATOR);
    }

    public static boolean isComplex(String path) {
        return path.contains(DEFAULT_SEPARATOR);
    }

    public Path(List<String> path, String separator) {
        Argument.checkNotNull(path, (String)"Can't create path from null list.", (Object[])new Object[0]);
        Argument.checkNotNull((Object)separator, (String)"Can't create path with null separator.", (Object[])new Object[0]);
        this.path = Collections.unmodifiableList(path);
        this.separator = separator;
    }

    public Path(List<String> path) {
        this(path, DEFAULT_SEPARATOR);
    }

    public Path newWithSeparator(String separator) {
        return new Path(this.path, separator);
    }

    public int size() {
        return this.path.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isComplex() {
        return this.size() > 1;
    }

    public Path subpath(int start, int end) {
        Argument.checkTrue((start >= 0 ? 1 : 0) != 0, (String)"Start index should be >= 0. Got: %d", (Object[])new Object[]{start});
        Argument.checkTrue((end <= this.path.size() ? 1 : 0) != 0, (String)"End index should be <= than path size. Got: %d", (Object[])new Object[]{end});
        Argument.checkTrue((start <= end ? 1 : 0) != 0, (String)"Start index should be <= than end index. Got start: %d end: %d", (Object[])new Object[]{start, end});
        List<String> newPath = this.path.subList(start, end);
        return new Path(newPath, this.separator);
    }

    public Path subpath() {
        return this.subpath(1, this.size());
    }

    public Path parent() {
        return this.subpath(0, this.path.size() - 1);
    }

    public Path child(String segment) {
        ArrayList<String> segments = new ArrayList<String>(this.path);
        segments.add(segment);
        return new Path(segments, this.separator);
    }

    public Path sibling(String segment) {
        return this.parent().child(segment);
    }

    public String get(int index) {
        Assert.checkFalse((boolean)this.path.isEmpty(), (String)"Can't get item of empty path.", (Object[])new Object[0]);
        return this.path.get(index);
    }

    public String getFirst() {
        Assert.checkFalse((boolean)this.path.isEmpty(), (String)"Can't get first item of empty path.", (Object[])new Object[0]);
        return this.path.get(0);
    }

    public String getLast() {
        Assert.checkFalse((boolean)this.path.isEmpty(), (String)"Can't get last item of empty path.", (Object[])new Object[0]);
        return this.get(this.path.size() - 1);
    }

    public String toString() {
        return this.join(this.path, 0, this.size(), this.separator);
    }

    private String join(List<String> path, int startIndex, int endIndex, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = startIndex; i < endIndex; ++i) {
            sb.append(path.get(i));
            if (i >= endIndex - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }
}

