/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.support;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.srplib.contract.Argument;
import org.srplib.support.Builder;

public class MapBuilder<K, V>
implements Builder<Map<K, V>> {
    private Map<K, V> map;

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> MapBuilder<K, V> map(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public static <K, V> MapBuilder<K, V> hashMap() {
        Map<K, V> map = MapBuilder.newHashMap();
        return MapBuilder.map(map);
    }

    public static <K, V> MapBuilder<K, V> linkedHashMap() {
        Map<K, V> map = MapBuilder.newLinkedHashMap();
        return MapBuilder.map(map);
    }

    public MapBuilder(Map<K, V> map) {
        Argument.checkNotNull(map, (String)"Map must not be null!", (Object[])new Object[0]);
        this.map = map;
    }

    public MapBuilder() {
        this(new HashMap());
    }

    public MapBuilder<K, V> put(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    @Override
    public Map<K, V> build() {
        return this.map;
    }
}

