/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.srplib.contract.Argument;
import org.srplib.support.Builder;

public class ListBuilder<T>
implements Builder<List<T>> {
    private List<T> list;

    public static <T> List<T> newArrayList(T ... array) {
        return new ArrayList<T>(Arrays.asList(array));
    }

    public static <T> List<T> newLinkedList(T ... array) {
        return new LinkedList<T>(Arrays.asList(array));
    }

    public static <T> ListBuilder<T> list(List<T> list) {
        return new ListBuilder<T>(list);
    }

    public static <T> ListBuilder<T> arrayList(T ... array) {
        return ListBuilder.list(ListBuilder.newArrayList(array));
    }

    public static <T> ListBuilder<T> linkedList(T ... array) {
        return ListBuilder.list(ListBuilder.newLinkedList(array));
    }

    public ListBuilder(List<T> list) {
        Argument.checkNotNull(list, (String)"List must not be null!", (Object[])new Object[0]);
        this.list = list;
    }

    public ListBuilder() {
        this(new ArrayList());
    }

    public ListBuilder<T> add(T value) {
        this.list.add(value);
        return this;
    }

    @Override
    public List<T> build() {
        return this.list;
    }
}

