/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.srplib.contract.Argument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    public static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(.(\\w+))*");
    public static final Version ZERO = Version.valueOf("0.0.0");
    public static final Version INITIAL = Version.valueOf("0.1.0");
    private int major;
    private int minor;
    private int patch;
    private String qualifier;

    public static Version valueOf(String string) {
        Argument.checkNotNull((Object)string, (String)"Version string must not be null!", (Object[])new Object[0]);
        Matcher matcher = VERSION_PATTERN.matcher(string);
        Argument.checkTrue((boolean)matcher.matches(), (String)"Version string '%s' doesn't conform semantic version format 'major.minor.patch[.qualifier]'.", (Object[])new Object[]{string});
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        String qualifier = matcher.group(5);
        return new Version(major, minor, patch, qualifier);
    }

    public Version(int major, int minor, int patch, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public Version nextMajor(boolean clearQualifier) {
        return new Version(this.major + 1, this.minor, this.patch, this.getQualifierOrEmpty(clearQualifier));
    }

    public Version nextMajor() {
        return this.nextMajor(true);
    }

    public Version nextMinor(boolean clearQualifier) {
        return new Version(this.major, this.minor + 1, this.patch, this.getQualifierOrEmpty(clearQualifier));
    }

    public Version nextMinor() {
        return this.nextMinor(true);
    }

    public Version nextPatch(boolean clearQualifier) {
        return new Version(this.major, this.minor, this.patch + 1, this.getQualifierOrEmpty(clearQualifier));
    }

    public Version nextPatch() {
        return this.nextPatch(true);
    }

    public String format() {
        String qualifierString = this.qualifier == null ? "" : "." + this.qualifier;
        return String.format("%d.%d.%d%s", this.major, this.minor, this.patch, qualifierString);
    }

    private String getQualifierOrEmpty(boolean clearQualifier) {
        return clearQualifier ? null : this.qualifier;
    }

    public String toString() {
        return "SemanticVersion{major=" + this.major + ", minor=" + this.minor + ", patch='" + this.patch + '\'' + '}';
    }

    @Override
    public int compareTo(Version that) {
        int majorCompare = this.compareTo(this.major, that.major);
        if (majorCompare != 0) {
            return majorCompare;
        }
        int minorCompare = this.compareTo(this.minor, that.minor);
        if (minorCompare != 0) {
            return minorCompare;
        }
        int patchCompare = this.compareTo(this.patch, that.patch);
        if (patchCompare != 0) {
            return patchCompare;
        }
        if (this.qualifier == null) {
            return that.qualifier == null ? 0 : -1;
        }
        return that.qualifier == null ? 1 : this.qualifier.compareTo(that.qualifier);
    }

    private int compareTo(int value1, int value2) {
        return value1 > value2 ? 1 : (value2 > value1 ? -1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        if (this.patch != version.patch) {
            return false;
        }
        return !(this.qualifier != null ? !this.qualifier.equals(version.qualifier) : version.qualifier != null);
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        return result;
    }
}

