/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.support;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.srplib.contract.Argument;
import org.srplib.support.Path;

public class PathUtils {
    public static final String PATH_SEPARATOR = "/";

    public static URI getRelative(URI uri, String relativePath) {
        return uri.resolve(relativePath);
    }

    public static URL getRelative(URL url, String relativePath) {
        URI resolved = PathUtils.toURI(url).resolve(relativePath);
        return PathUtils.toURL(resolved);
    }

    public static URI getSibling(URI uri, String segment) {
        Argument.checkNotNull((Object)uri, (String)"uri must not be null!", (Object[])new Object[0]);
        String sibling = PathUtils.getSibling(uri.getPath(), segment);
        return PathUtils.setPath(uri, sibling);
    }

    public static URL getSibling(URL url, String segment) {
        Argument.checkNotNull((Object)url, (String)"url must not be null!", (Object[])new Object[0]);
        return PathUtils.toURL(PathUtils.getSibling(PathUtils.toURI(url), segment));
    }

    public static File getSibling(File file, String segment) {
        Argument.checkNotNull((Object)file, (String)"file must not be null!", (Object[])new Object[0]);
        String path = file.getPath();
        return new File(PathUtils.getSibling(path, segment));
    }

    public static URI getChild(URI uri, String segment) {
        Argument.checkNotNull((Object)uri, (String)"uri must not be null!", (Object[])new Object[0]);
        String sibling = PathUtils.getChild(uri.getPath(), segment);
        return PathUtils.setPath(uri, sibling);
    }

    public static URL getChild(URL url, String segment) {
        Argument.checkNotNull((Object)url, (String)"url must not be null!", (Object[])new Object[0]);
        return PathUtils.toURL(PathUtils.getChild(PathUtils.toURI(url), segment));
    }

    public static File getChild(File file, String segment) {
        Argument.checkNotNull((Object)file, (String)"file must not be null!", (Object[])new Object[0]);
        String path = file.getPath();
        return new File(PathUtils.getChild(path, segment));
    }

    public static URI getParent(URI uri) {
        Argument.checkNotNull((Object)uri, (String)"uri must not be null!", (Object[])new Object[0]);
        String sibling = PathUtils.getParent(uri.getPath());
        return PathUtils.setPath(uri, sibling);
    }

    public static URL getParent(URL url) {
        Argument.checkNotNull((Object)url, (String)"url must not be null!", (Object[])new Object[0]);
        return PathUtils.toURL(PathUtils.getParent(PathUtils.toURI(url)));
    }

    public static File getParent(File file) {
        Argument.checkNotNull((Object)file, (String)"file must not be null!", (Object[])new Object[0]);
        String path = file.getPath();
        return new File(PathUtils.getParent(path));
    }

    public static String getSibling(String path, String segment) {
        return Path.parse(path, PATH_SEPARATOR).sibling(segment).toString();
    }

    public static String getChild(String path, String segment) {
        return Path.parse(path, PATH_SEPARATOR).child(segment).toString();
    }

    public static String getParent(String path) {
        return Path.parse(path, PATH_SEPARATOR).parent().toString();
    }

    public static URI setPath(URI uri, String path) {
        Argument.checkNotNull((Object)uri, (String)"uri must not be null!", (Object[])new Object[0]);
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Can't replace path in URI '%s' to '%s'.", uri, path));
        }
    }

    public static URL setPath(URL url, String path) {
        Argument.checkNotNull((Object)url, (String)"url must not be null!", (Object[])new Object[0]);
        try {
            URI uri = PathUtils.toURI(url);
            return PathUtils.setPath(uri, path).toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Can't replace path in URL '%s' to '%s'.", url, path));
        }
    }

    public static URI toURI(URL url) {
        Argument.checkNotNull((Object)url, (String)"url must not be null!", (Object[])new Object[0]);
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Can't convert URL '%s' to URI", url), e);
        }
    }

    public static URL toURL(URI uri) {
        Argument.checkNotNull((Object)uri, (String)"uri must not be null!", (Object[])new Object[0]);
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Can't convert URI '%s' to URL", uri), e);
        }
    }
}

