/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.support;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.srplib.contract.Argument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeKey
implements Serializable {
    private final List<?> components;

    public CompositeKey(List<?> components) {
        Argument.checkNotNull(components, (String)"Composite key component list must not be null!", (Object[])new Object[0]);
        this.components = Collections.unmodifiableList(components);
    }

    public CompositeKey(Object ... components) {
        this(Arrays.asList(components));
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        CompositeKey that = (CompositeKey)o;
        return this.components.equals(that.components);
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    public String toString() {
        return "Key " + this.components.toString();
    }
}

