/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.srplib.support.Builder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanBuilder {
    public static final String BUILD_METHOD = "build";

    public static <T, B extends Builder<T>> B create(T object, Class<B> builderInterface) {
        BeanBuilderInvocationHandler invocationHandler = new BeanBuilderInvocationHandler(object);
        return (B)((Builder)Proxy.newProxyInstance(BeanBuilder.class.getClassLoader(), new Class[]{builderInterface}, (InvocationHandler)invocationHandler));
    }

    private static class BeanBuilderInvocationHandler
    implements InvocationHandler {
        private Object object;

        private BeanBuilderInvocationHandler(Object object) {
            this.object = object;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            if (BeanBuilder.BUILD_METHOD.equals(method.getName())) {
                result = this.object;
            } else {
                Method originalMethod = this.getOriginalMethod(method);
                originalMethod.invoke(this.object, args);
                result = proxy;
            }
            return result;
        }

        private Method getOriginalMethod(Method method) {
            String originalMethodName = "set" + this.firstCharToUpper(method.getName());
            try {
                return this.object.getClass().getDeclaredMethod(originalMethodName, method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(String.format("Original method not found in class '%s'. Called builder's method: '%s', expected corresponding object's method: '%s'", this.object.getClass().getName(), method.getName(), originalMethodName), e);
            }
        }

        private String firstCharToUpper(String string) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
    }
}

