/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.srplib.contract.Argument;
import org.srplib.contract.Assert;
import org.srplib.reflection.ReflectionException;
import org.srplib.reflection.ReflectionUtils;
import org.srplib.reflection.ToStringHelper;
import org.srplib.support.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionInvoker<T, V> {
    private Class<T> clazz;
    private T target;
    private String methodName;
    private Class<?>[] parameters = new Class[0];
    private String errorMessagePattern;
    private Object[] errorMessageParameters;
    private static final String CONSTRUCTOR_NAME = "constructor";

    public static <T> ReflectionInvoker<T, T> constructor(Class<T> clazz) {
        Argument.checkNotNull(clazz, (String)"Can't create object with 'null' class!", (Object[])new Object[0]);
        return new ReflectionInvoker(clazz, null, new Class[0]);
    }

    public static <T, V> ReflectionInvoker<T, V> method(Class<T> clazz, String methodName) {
        Argument.checkNotNull(clazz, (String)"Can't create object of 'null' class!", (Object[])new Object[0]);
        return new ReflectionInvoker<T, V>(clazz, methodName, new Class[0]);
    }

    public static <T, V> ReflectionInvoker<T, V> method(T target, String methodName) {
        ReflectionInvoker<Class<?>, V> invoker = ReflectionInvoker.method(target.getClass(), methodName);
        invoker.target = target;
        return invoker;
    }

    public ReflectionInvoker(Class<T> clazz, String methodName, Class<?> ... parameters) {
        Argument.checkNotNull(clazz, (String)"Can't create object with 'null' class!", (Object[])new Object[0]);
        this.clazz = clazz;
        this.methodName = methodName;
        this.parameters = parameters;
    }

    public ReflectionInvoker<T, V> target(T target) {
        this.target = target;
        return this;
    }

    public ReflectionInvoker<T, V> parameters(List<Class<?>> types) {
        Argument.checkNotNull(types, (String)"Parameter parameters must not be null!", (Object[])new Object[0]);
        this.parameters((Class[])types.toArray());
        return this;
    }

    public ReflectionInvoker<T, V> parameters(Class<?> ... parameters) {
        if (this.isConstructorInvoker()) {
            Argument.checkTrue((boolean)ReflectionUtils.hasConstructor(this.clazz, parameters), (String)("No constructor " + ToStringHelper.toString(this.clazz, null, parameters)), (Object[])new Object[0]);
        } else {
            Argument.checkTrue((ReflectionUtils.findMethodRecursively(this.clazz, this.methodName, parameters) != null ? 1 : 0) != 0, (String)("No method " + ToStringHelper.toString(this.clazz, this.methodName, parameters)), (Object[])new Object[0]);
        }
        this.parameters = parameters;
        return this;
    }

    private boolean isConstructorInvoker() {
        return this.methodName == null;
    }

    public ReflectionInvoker<T, V> errorMessage(String pattern, Object ... parameters) {
        this.errorMessagePattern = pattern;
        this.errorMessageParameters = parameters;
        return this;
    }

    public V invoke(Object ... arguments) {
        try {
            if (this.isConstructorInvoker()) {
                return (V)ReflectionUtils.newInstance(this.clazz, this.parameters, arguments);
            }
            Method method = ReflectionUtils.getMethodRecursively(this.clazz, this.methodName, this.parameters);
            return (V)ReflectionUtils.invokeMethod(this.target, method, arguments);
        }
        catch (ReflectionException e) {
            throw new ReflectionException(this.getUserMessage() + " " + e.getMessage(), e);
        }
    }

    public static <T> T invokeMethod(Object target, Method method, Object ... arguments) {
        Argument.checkNotNull((Object)method, (String)"Argument 'method' must not be null!", (Object[])new Object[0]);
        Assert.checkTrue((Modifier.isStatic(method.getModifiers()) || target != null ? 1 : 0) != 0, (String)"Argument 'target' must not be null for non-static method.", (Object[])new Object[0]);
        boolean accessible = method.isAccessible();
        try {
            method.setAccessible(true);
            Object object = method.invoke(target, arguments);
            return (T)object;
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(ReflectionInvoker.getMethodInvocationErrorMessage(target.getClass(), method.getName(), method.getParameterTypes(), arguments), e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionUtils.asUnchecked(e.getCause());
        }
        finally {
            method.setAccessible(accessible);
        }
    }

    private static String getMethodInvocationErrorMessage(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
        return "Method invocation error " + ToStringHelper.toString(clazz, methodName, parameterTypes, parameters);
    }

    public static <T> T newInstance(Class<T> clazz, Class[] parameters, Object[] arguments) {
        try {
            if (parameters.length != arguments.length) {
                Argument.fail((String)(ReflectionInvoker.getInstanceCreationErrorMessage(clazz, parameters, arguments) + " Expecting %d arguments but actually got %d."), (Object[])new Object[]{parameters.length, arguments.length});
            }
            Constructor<T> constructor = clazz.getDeclaredConstructor(parameters);
            constructor.setAccessible(true);
            return constructor.newInstance(arguments);
        }
        catch (InstantiationException e) {
            throw new ReflectionException(ReflectionInvoker.getInstanceCreationErrorMessage(clazz, parameters, arguments), e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(ReflectionInvoker.getInstanceCreationErrorMessage(clazz, parameters, arguments), e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(ReflectionInvoker.getInstanceCreationErrorMessage(clazz, parameters, arguments), e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionUtils.asUnchecked(e.getCause());
        }
    }

    private static String getInstanceCreationErrorMessage(Class<?> clazz, Class<?>[] parameterTypes, Object[] parameters) {
        return "Instance creation error " + ToStringHelper.toString(clazz, CONSTRUCTOR_NAME, parameterTypes, parameters);
    }

    private String getUserMessage() {
        return this.errorMessagePattern == null ? "" : String.format(this.errorMessagePattern, this.errorMessageParameters);
    }
}

