/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.objectgraph;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.srplib.objectgraph.Element;
import org.srplib.objectgraph.Visitor;
import org.srplib.reflection.ReflectionUtils;

public class ObjectGraph
implements Element {
    private Object root;
    private Set<Integer> visitedIdentities = new HashSet<Integer>();

    public ObjectGraph(Object root) {
        this.root = root;
    }

    public void accept(Visitor visitor) {
        this.traverse(this.root, visitor);
    }

    private void traverse(Object object, Visitor visitor) {
        if (object == null) {
            return;
        }
        if (!this.isTraversable(object)) {
            return;
        }
        if (this.isVisited(object)) {
            return;
        }
        this.rememberVisited(object);
        visitor.visit(object);
        if (ReflectionUtils.isMap(object.getClass())) {
            this.traverseMap((Map)object, visitor);
        } else if (ReflectionUtils.isCollection(object.getClass())) {
            this.traverseCollection((Collection)object, visitor);
        } else if (ReflectionUtils.isArray(object.getClass())) {
            this.traverseArray((Object[])object, visitor);
        } else {
            this.traverseDeclaredFields(object.getClass(), object, visitor);
        }
    }

    private void rememberVisited(Object object) {
        int identity = this.identity(object);
        this.visitedIdentities.add(identity);
    }

    private boolean isVisited(Object object) {
        int identity = this.identity(object);
        return this.visitedIdentities.contains(identity);
    }

    private int identity(Object object) {
        return System.identityHashCode(object);
    }

    private void traverseMap(Map map, Visitor visitor) {
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = i$.next();
            this.traverse(entry.getKey(), visitor);
            this.traverse(entry.getValue(), visitor);
        }
    }

    private void traverseCollection(Collection collection, Visitor visitor) {
        for (Object valueItem : collection) {
            this.traverse(valueItem, visitor);
        }
    }

    private void traverseArray(Object[] array, Visitor visitor) {
        for (Object valueItem : array) {
            this.traverse(valueItem, visitor);
        }
    }

    private void traverseDeclaredFields(Class objectClass, Object object, Visitor visitor) {
        if (objectClass == Object.class) {
            return;
        }
        for (Field field : objectClass.getDeclaredFields()) {
            if (ReflectionUtils.isSyntheticName(field.getName())) continue;
            Object fieldValue = ReflectionUtils.getFieldValue(object, field);
            this.traverse(fieldValue, visitor);
        }
        this.traverseDeclaredFields(objectClass.getSuperclass(), object, visitor);
    }

    private boolean isTraversable(Object object) {
        return object != null && object.getClass() != Object.class && ReflectionUtils.isComplexType(object.getClass());
    }
}

