/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.srplib.contract.Argument;

public class Types {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE;
    private static final Map<Class<?>, Object> DEFAULT_VALUES;

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive();
    }

    public static boolean isPrimitiveArray(Class<?> type) {
        Argument.checkNotNull(type, (String)"'type' must not be null!", (Object[])new Object[0]);
        return Types.isArray(type) && type.getComponentType().isPrimitive();
    }

    public static boolean isWrapper(Class<?> clazz) {
        return WRAPPER_TO_PRIMITIVE.containsKey(clazz);
    }

    public static boolean isWrapperArray(Class<?> type) {
        Argument.checkNotNull(type, (String)"'type' must not be null!", (Object[])new Object[0]);
        return Types.isArray(type) && Types.isWrapper(type.getComponentType());
    }

    public static boolean isArray(Class<?> clazz) {
        Argument.checkNotNull(clazz, (String)"Can't examine 'null' class.", (Object[])new Object[0]);
        return clazz.isArray();
    }

    public static Set<Class<?>> getPrimitives() {
        return PRIMITIVE_TO_WRAPPER.keySet();
    }

    public static Set<Class<?>> getWrappers() {
        return WRAPPER_TO_PRIMITIVE.keySet();
    }

    public static <T> Class<T> getWrapper(Class<T> type) {
        Argument.checkNotNull(type, (String)"'type' must not be null!", (Object[])new Object[0]);
        return PRIMITIVE_TO_WRAPPER.get(type);
    }

    public static <T> Class<T> getPrimitive(Class<T> type) {
        Argument.checkNotNull(type, (String)"'type' must not be null!", (Object[])new Object[0]);
        return WRAPPER_TO_PRIMITIVE.get(type);
    }

    public static <T> T getDefaultValue(Class<T> type) {
        Argument.checkNotNull(type, (String)"'type' must not be null!", (Object[])new Object[0]);
        return (T)DEFAULT_VALUES.get(type);
    }

    public static boolean isNumber(Class<?> type) {
        return Number.class.isAssignableFrom(type);
    }

    static {
        DEFAULT_VALUES = new HashMap();
        HashMap<Class<Comparable<Boolean>>, Class> primitives = new HashMap<Class<Comparable<Boolean>>, Class>();
        primitives.put(Boolean.TYPE, Boolean.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPER = Collections.unmodifiableMap(primitives);
        HashMap<Class, Class<Comparable<Boolean>>> wrappers = new HashMap<Class, Class<Comparable<Boolean>>>();
        wrappers.put(Boolean.class, Boolean.TYPE);
        wrappers.put(Byte.class, Byte.TYPE);
        wrappers.put(Character.class, Character.TYPE);
        wrappers.put(Short.class, Short.TYPE);
        wrappers.put(Integer.class, Integer.TYPE);
        wrappers.put(Long.class, Long.TYPE);
        wrappers.put(Float.class, Float.TYPE);
        wrappers.put(Double.class, Double.TYPE);
        WRAPPER_TO_PRIMITIVE = Collections.unmodifiableMap(wrappers);
        DEFAULT_VALUES.put(Boolean.class, false);
        DEFAULT_VALUES.put(Byte.class, (byte)0);
        DEFAULT_VALUES.put(Character.class, Character.valueOf('\u0000'));
        DEFAULT_VALUES.put(Short.class, (short)0);
        DEFAULT_VALUES.put(Integer.class, 0);
        DEFAULT_VALUES.put(Long.class, 0L);
        DEFAULT_VALUES.put(Float.class, Float.valueOf(0.0f));
        DEFAULT_VALUES.put(Double.class, 0.0);
        DEFAULT_VALUES.put(Boolean.TYPE, false);
        DEFAULT_VALUES.put(Byte.TYPE, (byte)0);
        DEFAULT_VALUES.put(Character.TYPE, Character.valueOf('\u0000'));
        DEFAULT_VALUES.put(Short.TYPE, (short)0);
        DEFAULT_VALUES.put(Integer.TYPE, 0);
        DEFAULT_VALUES.put(Long.TYPE, 0L);
        DEFAULT_VALUES.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULT_VALUES.put(Double.TYPE, 0.0);
    }
}

