/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class NodePath<T>
implements Iterable<T> {
    private final NodePath<T> parent;
    private final T current;

    private NodePath(NodePath<T> parent, T node) {
        this.parent = parent;
        this.current = node;
    }

    public NodePath(T node) {
        this(null, node);
    }

    public T getCurrent() {
        return this.current;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public NodePath<T> getParent() {
        return this.parent;
    }

    public NodePath<T> add(T node) {
        return new NodePath<T>(this, node);
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator(this);
    }

    public String format(String separator) {
        List<T> nodes = this.getNodes();
        Collections.reverse(nodes);
        StringBuilder sb = new StringBuilder();
        Iterator<T> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            sb.append(iterator.hasNext() ? separator : "");
        }
        return sb.toString();
    }

    private List<T> getNodes() {
        ArrayList<T> nodes = new ArrayList<T>();
        for (T node : this) {
            nodes.add(node);
        }
        return nodes;
    }

    public String toString() {
        return this.format(" -> ");
    }

    private static class MyIterator<T>
    implements Iterator<T> {
        private NodePath<T> path;

        public MyIterator(NodePath<T> path) {
            this.path = path;
        }

        @Override
        public boolean hasNext() {
            return this.path != null;
        }

        @Override
        public T next() {
            T current = this.path.getCurrent();
            this.path = this.path.getParent();
            return current;
        }
    }
}

