/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.valuefactory.factories;

import java.util.Calendar;
import java.util.Date;
import org.srplib.reflection.valuefactory.TypeMeta;
import org.srplib.reflection.valuefactory.ValueFactory;
import org.srplib.reflection.valuefactory.factories.ConstantValueFactory;

public class DateValueFactory
implements ValueFactory<Date> {
    public static ValueFactory<Date> initial() {
        return new ConstantValueFactory<Date>(new Date(0L));
    }

    @Override
    public Date get(TypeMeta meta) {
        return DateValueFactory.initial().get(meta);
    }

    public static Date newDate(int year, int month, int day, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date newDate(int year, int month, int day) {
        return DateValueFactory.newDate(year, month, day, 0, 0, 0);
    }
}

