/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.valuefactory.factories;

import java.lang.reflect.Array;
import org.srplib.reflection.objectfactory.ClassGraphFactory;
import org.srplib.reflection.objectfactory.ConfigurableNodeValueFactory;
import org.srplib.reflection.objectfactory.NodeValueFactory;
import org.srplib.reflection.valuefactory.CompositeTypeMeta;
import org.srplib.reflection.valuefactory.NonDefaultValueFactory;
import org.srplib.reflection.valuefactory.TypeMeta;
import org.srplib.reflection.valuefactory.ValueFactory;

public class ArrayValueFactory<T>
implements ValueFactory<T> {
    private static final int ELEMENT_COUNT = 2;

    @Override
    public T get(TypeMeta meta) {
        Class<?> componentType = meta.getType().getComponentType();
        Object array = Array.newInstance(componentType, 2);
        this.createElements(array, meta);
        return (T)array;
    }

    private void createElements(T array, TypeMeta meta) {
        NodeValueFactory<Object> nodeValueFactory = meta instanceof CompositeTypeMeta ? ((CompositeTypeMeta)meta).getNodeValueFactory() : new ConfigurableNodeValueFactory(new NonDefaultValueFactory());
        for (int i = 0; i < 2; ++i) {
            Object element = ClassGraphFactory.newInstance(meta.getType().getComponentType(), nodeValueFactory);
            Array.set(array, i, element);
        }
    }
}

