/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.valuefactory;

import java.lang.reflect.Modifier;
import java.util.Objects;
import org.srplib.reflection.valuefactory.ValueFactoryException;

public class TypeMeta {
    private final Class<?> type;

    public TypeMeta(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getInstantiableType() {
        TypeMeta.checkInstantiable(this.type);
        return this.type;
    }

    public static void checkInstantiable(Class<?> type) {
        if (!TypeMeta.isInstantiable(type)) {
            throw new ValueFactoryException(String.format("Type %s is not instantiable!", type));
        }
    }

    public static boolean isInstantiable(Class<?> type) {
        return !type.isInterface() && !Modifier.isAbstract(type.getModifiers());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeMeta typeMeta = (TypeMeta)o;
        return Objects.equals(this.type, typeMeta.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public String toString() {
        return String.format("TypeMeta(%s)", this.type);
    }
}

