/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.valuefactory;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.srplib.conversion.Converter;
import org.srplib.conversion.mapper.MatcherMapBuilder;
import org.srplib.reflection.valuefactory.TypeMeta;
import org.srplib.reflection.valuefactory.ValueFactory;
import org.srplib.reflection.valuefactory.factories.ConstantValueFactory;

public class ConfigurableValueFactory
implements ValueFactory {
    private Converter<Class<?>, ValueFactory> converter;

    public Builder builder() {
        return new Builder();
    }

    private ConfigurableValueFactory(Converter<Class<?>, ValueFactory> converter) {
        this.converter = converter;
    }

    public Object get(TypeMeta meta) {
        ValueFactory valueFactory = (ValueFactory)this.converter.convert(meta.getType());
        return valueFactory.get(meta);
    }

    public static class Builder {
        private MatcherMapBuilder<Class<?>, ValueFactory> builder = MatcherMapBuilder.create().throwExceptionOnNoMatch(true);

        public static Builder create() {
            return new Builder();
        }

        public Builder register(Matcher<Class<?>> classMatcher, ValueFactory<?> valueFactory) {
            this.builder.map(classMatcher, valueFactory);
            return this;
        }

        public <T> Builder register(Class<T> type, ValueFactory<T> valueFactory) {
            this.register(Matchers.sameInstance(type), valueFactory);
            return this;
        }

        public <T> Builder register(Class<T> type, T value) {
            this.register(type, (T)new ConstantValueFactory<T>(value));
            return this;
        }

        public ValueFactory build() {
            return new ConfigurableValueFactory((Converter)this.builder.build());
        }
    }
}

