/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.objectgraph;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.srplib.reflection.Types;
import org.srplib.support.Predicate;

public class StandardTraversableClassesFilter
implements Predicate<Class<?>> {
    private static final Set<Class<?>> PROHIBITED_TYPES = new HashSet<Class>(Arrays.asList(Object.class, String.class, StringBuilder.class, StringBuffer.class, Date.class));

    public boolean test(Class<?> value) {
        return !this.isProhibited(value);
    }

    private boolean isProhibited(Class type) {
        return PROHIBITED_TYPES.contains(type) || Types.isPrimitive((Class)type) || Types.isPrimitiveArray((Class)type) || Types.isWrapper((Class)type) || Types.isWrapperArray((Class)type) || Types.isNumber((Class)type) || type.isEnum();
    }
}

