/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.objectgraph;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.srplib.contract.Argument;
import org.srplib.reflection.ReflectionUtils;
import org.srplib.reflection.objectgraph.Element;
import org.srplib.reflection.objectgraph.StandardTraversableClassesFilter;
import org.srplib.reflection.objectgraph.Visitor;
import org.srplib.support.Predicate;

public class ObjectGraph
implements Element {
    private Object root;
    private Set<Integer> visitedIdentities = new HashSet<Integer>();
    private Predicate<Class<?>> filter;

    public ObjectGraph(Object root, Predicate<Class<?>> filter) {
        Argument.checkNotNull((Object)root, (String)"root must not be null!", (Object[])new Object[0]);
        Argument.checkNotNull(filter, (String)"filter must not be null!", (Object[])new Object[0]);
        this.root = root;
        this.filter = filter;
    }

    public ObjectGraph(Object root) {
        this(root, new StandardTraversableClassesFilter());
    }

    @Override
    public void accept(Visitor visitor) {
        this.traverse(this.root, visitor);
    }

    private void traverse(Object object, Visitor visitor) {
        if (object == null) {
            return;
        }
        if (!this.isTraversable(object)) {
            return;
        }
        if (this.isVisited(object)) {
            return;
        }
        this.rememberVisited(object);
        visitor.visit(object);
        if (ReflectionUtils.isMap(object.getClass())) {
            this.traverseMap((Map)object, visitor);
        } else if (ReflectionUtils.isCollection(object.getClass())) {
            this.traverseCollection((Collection)object, visitor);
        } else if (ReflectionUtils.isArray(object.getClass())) {
            this.traverseArray((Object[])object, visitor);
        } else {
            this.traverseDeclaredFields(object.getClass(), object, visitor);
        }
    }

    private void rememberVisited(Object object) {
        int identity = this.identity(object);
        this.visitedIdentities.add(identity);
    }

    private boolean isVisited(Object object) {
        int identity = this.identity(object);
        return this.visitedIdentities.contains(identity);
    }

    private int identity(Object object) {
        return System.identityHashCode(object);
    }

    private void traverseMap(Map map, Visitor visitor) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            this.traverse(entry.getKey(), visitor);
            this.traverse(entry.getValue(), visitor);
        }
    }

    private void traverseCollection(Collection collection, Visitor visitor) {
        for (Object valueItem : collection) {
            this.traverse(valueItem, visitor);
        }
    }

    private void traverseArray(Object[] array, Visitor visitor) {
        for (Object valueItem : array) {
            this.traverse(valueItem, visitor);
        }
    }

    private void traverseDeclaredFields(Class objectClass, Object object, Visitor visitor) {
        if (objectClass == Object.class) {
            return;
        }
        for (Field field : objectClass.getDeclaredFields()) {
            if (ReflectionUtils.isSyntheticName((String)field.getName())) continue;
            Object fieldValue = ReflectionUtils.getFieldValue((Object)object, (Field)field);
            this.traverse(fieldValue, visitor);
        }
        this.traverseDeclaredFields(objectClass.getSuperclass(), object, visitor);
    }

    private boolean isTraversable(Object object) {
        return object != null && this.filter.test(object.getClass());
    }
}

