/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.objectfactory;

import java.util.HashMap;
import java.util.Map;
import org.srplib.contract.Argument;
import org.srplib.contract.Utils;
import org.srplib.reflection.classgraph.ClassGraphNode;
import org.srplib.reflection.objectfactory.NodeValueFactory;
import org.srplib.reflection.valuefactory.TypeMeta;
import org.srplib.reflection.valuefactory.ValueFactory;
import org.srplib.reflection.valuefactory.ValueFactoryException;
import org.srplib.support.CompositeKey;
import org.srplib.visitor.NodePath;

public class ConfigurableNodeValueFactory
implements NodeValueFactory<Object> {
    private final Map<CompositeKey, TypeMeta> nodeValueMeta = new HashMap<CompositeKey, TypeMeta>();
    private final Map<CompositeKey, ValueFactory<?>> valueFactories = new HashMap();
    private final ValueFactory defaultValueFactory;

    public ConfigurableNodeValueFactory(ValueFactory<?> defaultValueFactory) {
        Argument.checkNotNull(defaultValueFactory, (String)"defaultValueFactory must not be null!", (Object[])new Object[0]);
        this.defaultValueFactory = defaultValueFactory;
    }

    public void add(ClassGraphNode node, TypeMeta typeMeta) {
        this.nodeValueMeta.put(this.getKey(node), typeMeta);
    }

    public void add(ClassGraphNode node, ValueFactory valueFactory) {
        this.valueFactories.put(this.getKey(node), valueFactory);
    }

    @Override
    public Object get(NodePath<? extends ClassGraphNode> path) {
        try {
            ClassGraphNode node = path.getCurrent();
            TypeMeta typeMeta = this.getValueMeta(node);
            ValueFactory valueFactory = this.getValueFactory(node);
            return valueFactory.get(typeMeta);
        }
        catch (ValueFactoryException e) {
            throw new ValueFactoryException(String.format("Can't create value for node path '%s'", path), e);
        }
    }

    private TypeMeta getValueMeta(ClassGraphNode node) {
        TypeMeta typeMeta = this.nodeValueMeta.get(this.getKey(node));
        return (TypeMeta)Utils.getDefaultIfNull((Object)typeMeta, (Object)new TypeMeta(node.getType()));
    }

    private ValueFactory getValueFactory(ClassGraphNode node) {
        ValueFactory<?> valueFactory = this.valueFactories.get(this.getKey(node));
        return (ValueFactory)Utils.getDefaultIfNull(valueFactory, (Object)this.defaultValueFactory);
    }

    private CompositeKey getKey(ClassGraphNode node) {
        return node.getField() == null ? new CompositeKey(new Object[]{node.getType()}) : new CompositeKey(new Object[]{node.getField().getDeclaringClass(), node.getField().getName()});
    }
}

