/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.objectfactory;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.srplib.reflection.ReflectionUtils;
import org.srplib.reflection.classgraph.ClassGraph;
import org.srplib.reflection.classgraph.ClassGraphNode;
import org.srplib.reflection.classgraph.ClassGraphVisitor;
import org.srplib.reflection.objectfactory.ClassGraphFactoryNode;
import org.srplib.reflection.objectfactory.NodeValueFactory;
import org.srplib.visitor.NodePath;

public class ClassGraphFactory
implements ClassGraphVisitor<ClassGraphFactoryNode> {
    private ClassGraphFactoryNode root;
    private NodeValueFactory valueFactory;

    public static <T> T newInstance(Class<T> type, NodeValueFactory valueFactory) {
        ClassGraphFactory visitor = new ClassGraphFactory(valueFactory);
        new ClassGraph(type).accept(visitor);
        return visitor.getResult();
    }

    public ClassGraphFactory(NodeValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public <T> T getResult() {
        return (T)this.root.getObject();
    }

    @Override
    public void visit(NodePath<ClassGraphFactoryNode> path) {
        ClassGraphFactoryNode current = path.getCurrent();
        this.rememberIfRootNode(current);
        if (!this.shouldCreateInstance(current)) {
            return;
        }
        Object value = this.valueFactory.get(path);
        current.setObject(value);
        if (path.hasParent()) {
            Field field = current.getField();
            ReflectionUtils.setFieldValue((Object)path.getParent().getCurrent().getObject(), (Field)field, value);
        }
    }

    private void rememberIfRootNode(ClassGraphFactoryNode node) {
        if (node.isRoot()) {
            this.root = node;
        }
    }

    private boolean shouldCreateInstance(ClassGraphFactoryNode node) {
        return node.isRoot() || this.isAssignableField(node);
    }

    private boolean isAssignableField(ClassGraphFactoryNode node) {
        return !Modifier.isStatic(node.getField().getModifiers());
    }

    @Override
    public ClassGraphFactoryNode resolveNode(ClassGraphNode node) {
        return new ClassGraphFactoryNode(node.getType(), node.getField());
    }
}

