/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.deepcompare.support;

import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.srplib.contract.Argument;
import org.srplib.reflection.deepcompare.ConfigurableDeepComparator;
import org.srplib.reflection.deepcompare.support.StandardConfiguration;

public class DeepComparatorMatcher
extends BaseMatcher<Object> {
    private ConfigurableDeepComparator deepComparator;
    private Object expected;
    private List<String> diffs;

    public DeepComparatorMatcher(ConfigurableDeepComparator deepComparator, Object expected) {
        Argument.checkNotNull((Object)deepComparator, (String)"deepComparator must not be null!", (Object[])new Object[0]);
        Argument.checkNotNull((Object)expected, (String)"expected must not be null!", (Object[])new Object[0]);
        this.deepComparator = deepComparator;
        this.expected = expected;
    }

    public boolean matches(Object actual) {
        this.diffs = this.deepComparator.compare(this.expected, actual);
        return this.diffs.isEmpty();
    }

    public void describeTo(Description description) {
        description.appendValue(this.expected);
    }

    public void describeMismatch(Object item, Description description) {
        description.appendValue(item);
        description.appendText("\n");
        for (String diff : this.diffs) {
            description.appendText(diff);
            description.appendText("\n");
        }
    }

    public static DeepComparatorMatcher deepCompare(Object expected) {
        ConfigurableDeepComparator deepComparator = new ConfigurableDeepComparator(new StandardConfiguration());
        return new DeepComparatorMatcher(deepComparator, expected);
    }
}

