/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.deepcompare.comparators;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.srplib.contract.Argument;
import org.srplib.reflection.ReflectionUtils;
import org.srplib.reflection.deepcompare.DeepComparator;
import org.srplib.reflection.deepcompare.DeepComparatorContext;
import org.srplib.support.Predicate;

public class ReflectionDeepComparator
implements DeepComparator<Object> {
    private Predicate<Field> comparables;

    public ReflectionDeepComparator(Predicate<Field> comparables) {
        Argument.checkNotNull(comparables, (String)"comparables must not be null!", (Object[])new Object[0]);
        this.comparables = comparables;
    }

    public ReflectionDeepComparator() {
        this(new NonStaticAndNonSynthenticFilter());
    }

    @Override
    public void compare(Object object1, Object object2, DeepComparatorContext context) {
        for (Field field : ReflectionUtils.getFieldsRecursively(object1.getClass())) {
            if (!this.comparables.test((Object)field)) continue;
            Object value1 = ReflectionUtils.getFieldValue((Object)object1, (Field)field);
            Object value2 = ReflectionUtils.getFieldValue((Object)object2, (Field)field);
            context.compareNested(value1, value2, field.getName());
        }
    }

    private static class NonStaticAndNonSynthenticFilter
    implements Predicate<Field> {
        private NonStaticAndNonSynthenticFilter() {
        }

        public boolean test(Field field) {
            return !ReflectionUtils.isSyntheticName((String)field.getName()) && !Modifier.isStatic(field.getModifiers());
        }
    }
}

