/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.deepcompare.comparators;

import org.srplib.contract.Argument;
import org.srplib.reflection.deepcompare.DeepComparator;
import org.srplib.reflection.deepcompare.DeepComparatorContext;

public class ReferenceComparatorDecorator<T>
implements DeepComparator<T> {
    private DeepComparator<T> delegate;
    private boolean checkClass;

    public ReferenceComparatorDecorator(DeepComparator<T> delegate, boolean checkClass) {
        Argument.checkNotNull(delegate, (String)"delegate must not be null!", (Object[])new Object[0]);
        this.delegate = delegate;
        this.checkClass = checkClass;
    }

    public ReferenceComparatorDecorator(DeepComparator<T> delegate) {
        this(delegate, false);
    }

    @Override
    public void compare(T object1, T object2, DeepComparatorContext context) {
        if (object1 == object2) {
            return;
        }
        if (object1 == null || object2 == null) {
            context.registerMismatch("Compare null and non-null values. Expected: '%s' actual: '%s'", object1, object2);
            return;
        }
        if (this.checkClass && object1.getClass() != object2.getClass()) {
            context.registerMismatch("Different classes. Expected: '%s' actual: '%s'", object1.getClass(), object2.getClass());
            return;
        }
        this.delegate.compare(object1, object2, context);
    }
}

