/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.deepcompare;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.srplib.reflection.deepcompare.DeepComparator;
import org.srplib.reflection.deepcompare.DeepComparatorContext;
import org.srplib.visitor.NodePath;

public class DeepComparatorContextImpl
implements DeepComparatorContext {
    private final DeepComparator rootComparator;
    private final NodePath<String> path;
    private List<String> mismatches;

    public DeepComparatorContextImpl(DeepComparator rootComparator) {
        this(rootComparator, new NodePath<String>("root"), new ArrayList<String>());
    }

    private DeepComparatorContextImpl(DeepComparator rootComparator, NodePath<String> root, List<String> mismatches) {
        this.rootComparator = rootComparator;
        this.path = root;
        this.mismatches = mismatches;
    }

    @Override
    public void compareNested(Object object1, Object object2, String node) {
        this.compare(object1, object2, this.path.add(node));
    }

    private void compare(Object object1, Object object2, NodePath<String> path) {
        this.rootComparator.compare(object1, object2, new DeepComparatorContextImpl(this.rootComparator, path, this.mismatches));
    }

    @Override
    public void compare(Object object1, Object object2) {
        this.compare(object1, object2, this.path);
    }

    @Override
    public void registerMismatch(String pattern, Object ... arguments) {
        String providedMessage = String.format(pattern, arguments);
        String contextMessage = String.format("Mismatch at path '%s'. %s", this.path.format("."), providedMessage);
        this.mismatches.add(contextMessage);
    }

    public List<String> getMismatches() {
        return Collections.unmodifiableList(this.mismatches);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String mismatch : this.mismatches) {
            sb.append(mismatch).append("\n");
        }
        return sb.toString();
    }
}

