/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.deepcompare;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.srplib.contract.Argument;
import org.srplib.reflection.deepcompare.DeepComparator;
import org.srplib.reflection.deepcompare.DeepComparatorConfiguration;
import org.srplib.reflection.deepcompare.DeepComparatorContext;
import org.srplib.reflection.deepcompare.DeepComparatorContextImpl;
import org.srplib.reflection.deepcompare.comparators.ReferenceComparatorDecorator;
import org.srplib.reflection.deepcompare.support.StandardConfiguration;
import org.srplib.support.CompositeKey;

public class ConfigurableDeepComparator
implements DeepComparator {
    private Set<CompositeKey> processedIdentities = new HashSet<CompositeKey>();
    private DeepComparatorConfiguration configuration;

    public ConfigurableDeepComparator(DeepComparatorConfiguration configuration) {
        Argument.checkNotNull((Object)configuration, (String)"configuration must not be null!", (Object[])new Object[0]);
        this.configuration = configuration;
    }

    public ConfigurableDeepComparator() {
        this(new StandardConfiguration());
    }

    public List<String> compare(Object object1, Object object2) {
        ReferenceComparatorDecorator rootComparator = new ReferenceComparatorDecorator(this);
        DeepComparatorContextImpl context = new DeepComparatorContextImpl(rootComparator);
        this.compare(object1, object2, (DeepComparatorContext)context);
        return context.getMismatches();
    }

    public void compare(Object object1, Object object2, DeepComparatorContext context) {
        if (this.alreadyProcessed(object1, object2)) {
            return;
        }
        this.rememberProcessed(object1, object2);
        ReferenceComparatorDecorator<Object> comparator = this.configuration.getComparator(object1.getClass());
        comparator = new ReferenceComparatorDecorator<Object>(comparator);
        comparator.compare(object1, object2, context);
    }

    private void rememberProcessed(Object object1, Object object2) {
        CompositeKey key = this.getKey(object1, object2);
        this.processedIdentities.add(key);
    }

    private boolean alreadyProcessed(Object object1, Object object2) {
        CompositeKey key = this.getKey(object1, object2);
        return this.processedIdentities.contains(key);
    }

    private CompositeKey getKey(Object object1, Object object2) {
        return new CompositeKey(new Object[]{this.identity(object1), this.identity(object2)});
    }

    private int identity(Object object) {
        return System.identityHashCode(object);
    }
}

